@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Office365 linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property office365TenantId Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property servicePrincipalId Specify the application's client ID. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey Specify the application's key.
 * @property servicePrincipalTenantId Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Office365'.
 */
public data class Office365LinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val office365TenantId: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val servicePrincipalId: Any,
    public val servicePrincipalKey:
    Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>,
    public val servicePrincipalTenantId: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.Office365LinkedServiceResponse):
            Office365LinkedServiceResponse = Office365LinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            office365TenantId = javaType.office365TenantId(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            servicePrincipalId = javaType.servicePrincipalId(),
            servicePrincipalKey = javaType.servicePrincipalKey().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            servicePrincipalTenantId = javaType.servicePrincipalTenantId(),
            type = javaType.type(),
        )
    }
}
