@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Package store for the SSIS integration runtime.
 * @property name The name of the package store
 * @property packageStoreLinkedService The package store linked service reference.
 */
public data class PackageStoreResponse(
    public val name: String,
    public val packageStoreLinkedService: EntityReferenceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PackageStoreResponse):
            PackageStoreResponse = PackageStoreResponse(
            name = javaType.name(),
            packageStoreLinkedService = javaType.packageStoreLinkedService().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.EntityReferenceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
