@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * QuickBooks server linked service.
 * @property accessToken The access token for OAuth 1.0 authentication.
 * @property accessTokenSecret The access token secret for OAuth 1.0 authentication.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property companyId The company ID of the QuickBooks company to authorize.
 * @property connectVia The integration runtime reference.
 * @property connectionProperties Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type: object.
 * @property consumerKey The consumer key for OAuth 1.0 authentication.
 * @property consumerSecret The consumer secret for OAuth 1.0 authentication.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'QuickBooks'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 */
public data class QuickBooksLinkedServiceResponse(
    public val accessToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val accessTokenSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val annotations: List<Any>? = null,
    public val companyId: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionProperties: Any? = null,
    public val consumerKey: Any? = null,
    public val consumerSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val endpoint: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val type: String,
    public val useEncryptedEndpoints: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.QuickBooksLinkedServiceResponse):
            QuickBooksLinkedServiceResponse = QuickBooksLinkedServiceResponse(
            accessToken = javaType.accessToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            accessTokenSecret = javaType.accessTokenSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            companyId = javaType.companyId().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionProperties = javaType.connectionProperties().map({ args0 -> args0 }).orElse(null),
            consumerKey = javaType.consumerKey().map({ args0 -> args0 }).orElse(null),
            consumerSecret = javaType.consumerSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            type = javaType.type(),
            useEncryptedEndpoints = javaType.useEncryptedEndpoints().map({ args0 -> args0 }).orElse(null),
        )
    }
}
