@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity Rest service source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property httpRequestTimeout The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data. Default value: 00:01:40. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property paginationRules The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
 * @property requestBody The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
 * @property requestInterval The time to await before sending next page request.
 * @property requestMethod The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'RestSource'.
 */
public data class RestSourceResponse(
    public val additionalColumns: Any? = null,
    public val additionalHeaders: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val httpRequestTimeout: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val paginationRules: Any? = null,
    public val requestBody: Any? = null,
    public val requestInterval: Any? = null,
    public val requestMethod: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RestSourceResponse):
            RestSourceResponse = RestSourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            additionalHeaders = javaType.additionalHeaders().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            httpRequestTimeout = javaType.httpRequestTimeout().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            paginationRules = javaType.paginationRules().map({ args0 -> args0 }).orElse(null),
            requestBody = javaType.requestBody().map({ args0 -> args0 }).orElse(null),
            requestInterval = javaType.requestInterval().map({ args0 -> args0 }).orElse(null),
            requestMethod = javaType.requestMethod().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
