@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * SSIS package execution log location
 * @property accessCredential The package execution log access credential.
 * @property logPath The SSIS package execution log path. Type: string (or Expression with resultType string).
 * @property logRefreshInterval Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type The type of SSIS log location.
 */
public data class SSISLogLocationResponse(
    public val accessCredential: SSISAccessCredentialResponse? = null,
    public val logPath: Any,
    public val logRefreshInterval: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SSISLogLocationResponse):
            SSISLogLocationResponse = SSISLogLocationResponse(
            accessCredential = javaType.accessCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SSISAccessCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logPath = javaType.logPath(),
            logRefreshInterval = javaType.logRefreshInterval().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
