@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity source for SAP Table source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property batchSize Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer (or Expression with resultType integer).
 * @property customRfcReadTableFunctionModule Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property partitionOption The partition mechanism that will be used for SAP table read in parallel. Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth", "PartitionOnCalendarDate", "PartitionOnTime".
 * @property partitionSettings The settings that will be leveraged for SAP table source partitioning.
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property rfcTableFields The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType string).
 * @property rfcTableOptions The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType string).
 * @property rowCount The number of rows to be retrieved. Type: integer(or Expression with resultType integer).
 * @property rowSkips The number of rows that will be skipped. Type: integer (or Expression with resultType integer).
 * @property sapDataColumnDelimiter The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'SapTableSource'.
 */
public data class SapTableSourceResponse(
    public val additionalColumns: Any? = null,
    public val batchSize: Any? = null,
    public val customRfcReadTableFunctionModule: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val partitionOption: Any? = null,
    public val partitionSettings: SapTablePartitionSettingsResponse? = null,
    public val queryTimeout: Any? = null,
    public val rfcTableFields: Any? = null,
    public val rfcTableOptions: Any? = null,
    public val rowCount: Any? = null,
    public val rowSkips: Any? = null,
    public val sapDataColumnDelimiter: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapTableSourceResponse):
            SapTableSourceResponse = SapTableSourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            customRfcReadTableFunctionModule = javaType.customRfcReadTableFunctionModule().map({ args0 ->
                args0
            }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            partitionOption = javaType.partitionOption().map({ args0 -> args0 }).orElse(null),
            partitionSettings = javaType.partitionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SapTablePartitionSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryTimeout = javaType.queryTimeout().map({ args0 -> args0 }).orElse(null),
            rfcTableFields = javaType.rfcTableFields().map({ args0 -> args0 }).orElse(null),
            rfcTableOptions = javaType.rfcTableOptions().map({ args0 -> args0 }).orElse(null),
            rowCount = javaType.rowCount().map({ args0 -> args0 }).orElse(null),
            rowSkips = javaType.rowSkips().map({ args0 -> args0 }).orElse(null),
            sapDataColumnDelimiter = javaType.sapDataColumnDelimiter().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
