@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Script activity type.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property linkedServiceName Linked service reference.
 * @property logSettings Log settings of script activity.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property scriptBlockExecutionTimeout ScriptBlock execution timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property scripts Array of script blocks. Type: array.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Script'.
 * @property userProperties Activity user properties.
 */
public data class ScriptActivityResponse(
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val logSettings: ScriptActivityTypePropertiesResponseLogSettings? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val scriptBlockExecutionTimeout: Any? = null,
    public val scripts: List<ScriptActivityScriptBlockResponse>? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ScriptActivityResponse):
            ScriptActivityResponse = ScriptActivityResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            logSettings = javaType.logSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ScriptActivityTypePropertiesResponseLogSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scriptBlockExecutionTimeout = javaType.scriptBlockExecutionTimeout().map({ args0 ->
                args0
            }).orElse(null),
            scripts = javaType.scripts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ScriptActivityScriptBlockResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
