@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * ServiceNow server linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to use.
 * @property clientId The client id for OAuth2 authentication.
 * @property clientSecret The client secret for OAuth2 authentication.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of the ServiceNow server. (i.e. <instance>.service-now.com)
 * @property parameters Parameters for linked service.
 * @property password The password corresponding to the user name for Basic and OAuth2 authentication.
 * @property type Type of linked service.
 * Expected value is 'ServiceNow'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 * @property username The user name used to connect to the ServiceNow server for Basic and OAuth2 authentication.
 */
public data class ServiceNowLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authenticationType: String,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val endpoint: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val type: String,
    public val useEncryptedEndpoints: Any? = null,
    public val useHostVerification: Any? = null,
    public val usePeerVerification: Any? = null,
    public val username: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ServiceNowLinkedServiceResponse):
            ServiceNowLinkedServiceResponse = ServiceNowLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType(),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
            useEncryptedEndpoints = javaType.useEncryptedEndpoints().map({ args0 -> args0 }).orElse(null),
            useHostVerification = javaType.useHostVerification().map({ args0 -> args0 }).orElse(null),
            usePeerVerification = javaType.usePeerVerification().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
