@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Sftp write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property operationTimeout Specifies the timeout for writing each chunk to SFTP server. Default value: 01:00:00 (one hour). Type: string (or Expression with resultType string).
 * @property type The write setting type.
 * Expected value is 'SftpWriteSettings'.
 * @property useTempFileRename Upload to temporary file(s) and rename. Disable this option if your SFTP server doesn't support rename operation. Type: boolean (or Expression with resultType boolean).
 */
public data class SftpWriteSettingsResponse(
    public val copyBehavior: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val operationTimeout: Any? = null,
    public val type: String,
    public val useTempFileRename: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SftpWriteSettingsResponse):
            SftpWriteSettingsResponse = SftpWriteSettingsResponse(
            copyBehavior = javaType.copyBehavior().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            operationTimeout = javaType.operationTimeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useTempFileRename = javaType.useTempFileRename().map({ args0 -> args0 }).orElse(null),
        )
    }
}
