@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Sql upsert option settings
 * @property interimSchemaName Schema name for interim table. Type: string (or Expression with resultType string).
 * @property keys Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
 * @property useTempDB Specifies whether to use temp db for upsert interim table. Type: boolean (or Expression with resultType boolean).
 */
public data class SqlUpsertSettingsResponse(
    public val interimSchemaName: Any? = null,
    public val keys: Any? = null,
    public val useTempDB: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SqlUpsertSettingsResponse):
            SqlUpsertSettingsResponse = SqlUpsertSettingsResponse(
            interimSchemaName = javaType.interimSchemaName().map({ args0 -> args0 }).orElse(null),
            keys = javaType.keys().map({ args0 -> args0 }).orElse(null),
            useTempDB = javaType.useTempDB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
