@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Ssis project.
 * @property description Metadata description.
 * @property environmentRefs Environment reference in project
 * @property folderId Folder id which contains project.
 * @property id Metadata id.
 * @property name Metadata name.
 * @property parameters Parameters in project
 * @property type The type of SSIS object metadata.
 * Expected value is 'Project'.
 * @property version Project version.
 */
public data class SsisProjectResponse(
    public val description: String? = null,
    public val environmentRefs: List<SsisEnvironmentReferenceResponse>? = null,
    public val folderId: Double? = null,
    public val id: Double? = null,
    public val name: String? = null,
    public val parameters: List<SsisParameterResponse>? = null,
    public val type: String,
    public val version: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SsisProjectResponse):
            SsisProjectResponse = SsisProjectResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            environmentRefs = javaType.environmentRefs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SsisEnvironmentReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            folderId = javaType.folderId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SsisParameterResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
