@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Synapse spark job reference type.
 * @property referenceName Reference spark job name. Expression with resultType string.
 * @property type Synapse spark job reference type.
 */
public data class SynapseSparkJobReferenceResponse(
    public val referenceName: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SynapseSparkJobReferenceResponse):
            SynapseSparkJobReferenceResponse = SynapseSparkJobReferenceResponse(
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
