@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * The settings that will be leveraged for teradata source partitioning.
 * @property partitionColumnName The name of the column that will be used for proceeding range or hash partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class TeradataPartitionSettingsResponse(
    public val partitionColumnName: Any? = null,
    public val partitionLowerBound: Any? = null,
    public val partitionUpperBound: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TeradataPartitionSettingsResponse):
            TeradataPartitionSettingsResponse = TeradataPartitionSettingsResponse(
            partitionColumnName = javaType.partitionColumnName().map({ args0 -> args0 }).orElse(null),
            partitionLowerBound = javaType.partitionLowerBound().map({ args0 -> args0 }).orElse(null),
            partitionUpperBound = javaType.partitionUpperBound().map({ args0 -> args0 }).orElse(null),
        )
    }
}
