@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Referenced tumbling window trigger dependency.
 * @property offset Timespan applied to the start time of a tumbling window when evaluating dependency.
 * @property referenceTrigger Referenced trigger.
 * @property size The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
 * @property type The type of dependency reference.
 * Expected value is 'TumblingWindowTriggerDependencyReference'.
 */
public data class TumblingWindowTriggerDependencyReferenceResponse(
    public val offset: String? = null,
    public val referenceTrigger: TriggerReferenceResponse,
    public val size: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TumblingWindowTriggerDependencyReferenceResponse):
            TumblingWindowTriggerDependencyReferenceResponse =
            TumblingWindowTriggerDependencyReferenceResponse(
                offset = javaType.offset().map({ args0 -> args0 }).orElse(null),
                referenceTrigger = javaType.referenceTrigger().let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerReferenceResponse.Companion.toKotlin(args0)
                }),
                size = javaType.size().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
