@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A WebLinkedService that uses anonymous authentication to communicate with an HTTP endpoint.
 * @property authenticationType Type of authentication used to connect to the web table source.
 * Expected value is 'Anonymous'.
 * @property url The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
 */
public data class WebAnonymousAuthenticationResponse(
    public val authenticationType: String,
    public val url: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WebAnonymousAuthenticationResponse):
            WebAnonymousAuthenticationResponse = WebAnonymousAuthenticationResponse(
            authenticationType = javaType.authenticationType(),
            url = javaType.url(),
        )
    }
}
