@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Web linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'Web'.
 * @property typeProperties Web linked service properties.
 */
public data class WebLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val type: String,
    public val typeProperties: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WebLinkedServiceResponse):
            WebLinkedServiceResponse = WebLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            type = javaType.type(),
            typeProperties = javaType.typeProperties(),
        )
    }
}
