@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The ZipDeflate compression read settings.
 * @property preserveZipFileNameAsFolder Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean).
 * @property type The Compression setting type.
 * Expected value is 'ZipDeflateReadSettings'.
 */
public data class ZipDeflateReadSettingsResponse(
    public val preserveZipFileNameAsFolder: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ZipDeflateReadSettingsResponse):
            ZipDeflateReadSettingsResponse = ZipDeflateReadSettingsResponse(
            preserveZipFileNameAsFolder = javaType.preserveZipFileNameAsFolder().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
