@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin

import com.pulumi.azurenative.datalakeanalytics.AccountArgs.builder
import com.pulumi.azurenative.datalakeanalytics.kotlin.enums.FirewallAllowAzureIpsState
import com.pulumi.azurenative.datalakeanalytics.kotlin.enums.FirewallState
import com.pulumi.azurenative.datalakeanalytics.kotlin.enums.TierType
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.AddDataLakeStoreWithAccountParametersArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.AddDataLakeStoreWithAccountParametersArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.AddStorageAccountWithAccountParametersArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.AddStorageAccountWithAccountParametersArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.CreateComputePolicyWithAccountParametersArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.CreateComputePolicyWithAccountParametersArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.CreateFirewallRuleWithAccountParametersArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.CreateFirewallRuleWithAccountParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2016-11-01.
 * Other available API versions: 2015-10-01-preview.
 * ## Example Usage
 * ### Creates the specified Data Lake Analytics account. This supplies the user with computation services for Data Lake Analytics workloads.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.DataLakeAnalytics.Account("account", new()
 *     {
 *         AccountName = "contosoadla",
 *         ComputePolicies = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.CreateComputePolicyWithAccountParametersArgs
 *             {
 *                 MaxDegreeOfParallelismPerJob = 1,
 *                 MinPriorityPerJob = 1,
 *                 Name = "test_policy",
 *                 ObjectId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
 *                 ObjectType = "User",
 *             },
 *         },
 *         DataLakeStoreAccounts = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.AddDataLakeStoreWithAccountParametersArgs
 *             {
 *                 Name = "test_adls",
 *                 Suffix = "test_suffix",
 *             },
 *         },
 *         DefaultDataLakeStoreAccount = "test_adls",
 *         FirewallAllowAzureIps = AzureNative.DataLakeAnalytics.FirewallAllowAzureIpsState.Enabled,
 *         FirewallRules = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.CreateFirewallRuleWithAccountParametersArgs
 *             {
 *                 EndIpAddress = "2.2.2.2",
 *                 Name = "test_rule",
 *                 StartIpAddress = "1.1.1.1",
 *             },
 *         },
 *         FirewallState = AzureNative.DataLakeAnalytics.FirewallState.Enabled,
 *         Location = "eastus2",
 *         MaxDegreeOfParallelism = 30,
 *         MaxDegreeOfParallelismPerJob = 1,
 *         MaxJobCount = 3,
 *         MinPriorityPerJob = 1,
 *         NewTier = AzureNative.DataLakeAnalytics.TierType.Consumption,
 *         QueryStoreRetention = 30,
 *         ResourceGroupName = "contosorg",
 *         StorageAccounts = new[]
 *         {
 *             new AzureNative.DataLakeAnalytics.Inputs.AddStorageAccountWithAccountParametersArgs
 *             {
 *                 AccessKey = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab346",
 *                 Name = "test_storage",
 *                 Suffix = "test_suffix",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "test_key", "test_value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakeanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakeanalytics.NewAccount(ctx, "account", &datalakeanalytics.AccountArgs{
 * 			AccountName: pulumi.String("contosoadla"),
 * 			ComputePolicies: []datalakeanalytics.CreateComputePolicyWithAccountParametersArgs{
 * 				{
 * 					MaxDegreeOfParallelismPerJob: pulumi.Int(1),
 * 					MinPriorityPerJob:            pulumi.Int(1),
 * 					Name:                         pulumi.String("test_policy"),
 * 					ObjectId:                     pulumi.String("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345"),
 * 					ObjectType:                   pulumi.String("User"),
 * 				},
 * 			},
 * 			DataLakeStoreAccounts: []datalakeanalytics.AddDataLakeStoreWithAccountParametersArgs{
 * 				{
 * 					Name:   pulumi.String("test_adls"),
 * 					Suffix: pulumi.String("test_suffix"),
 * 				},
 * 			},
 * 			DefaultDataLakeStoreAccount: pulumi.String("test_adls"),
 * 			FirewallAllowAzureIps:       datalakeanalytics.FirewallAllowAzureIpsStateEnabled,
 * 			FirewallRules: []datalakeanalytics.CreateFirewallRuleWithAccountParametersArgs{
 * 				{
 * 					EndIpAddress:   pulumi.String("2.2.2.2"),
 * 					Name:           pulumi.String("test_rule"),
 * 					StartIpAddress: pulumi.String("1.1.1.1"),
 * 				},
 * 			},
 * 			FirewallState:                datalakeanalytics.FirewallStateEnabled,
 * 			Location:                     pulumi.String("eastus2"),
 * 			MaxDegreeOfParallelism:       pulumi.Int(30),
 * 			MaxDegreeOfParallelismPerJob: pulumi.Int(1),
 * 			MaxJobCount:                  pulumi.Int(3),
 * 			MinPriorityPerJob:            pulumi.Int(1),
 * 			NewTier:                      datalakeanalytics.TierTypeConsumption,
 * 			QueryStoreRetention:          pulumi.Int(30),
 * 			ResourceGroupName:            pulumi.String("contosorg"),
 * 			StorageAccounts: []datalakeanalytics.AddStorageAccountWithAccountParametersArgs{
 * 				{
 * 					AccessKey: pulumi.String("34adfa4f-cedf-4dc0-ba29-b6d1a69ab346"),
 * 					Name:      pulumi.String("test_storage"),
 * 					Suffix:    pulumi.String("test_suffix"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"test_key": pulumi.String("test_value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakeanalytics.Account;
 * import com.pulumi.azurenative.datalakeanalytics.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("contosoadla")
 *             .computePolicies(Map.ofEntries(
 *                 Map.entry("maxDegreeOfParallelismPerJob", 1),
 *                 Map.entry("minPriorityPerJob", 1),
 *                 Map.entry("name", "test_policy"),
 *                 Map.entry("objectId", "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345"),
 *                 Map.entry("objectType", "User")
 *             ))
 *             .dataLakeStoreAccounts(Map.ofEntries(
 *                 Map.entry("name", "test_adls"),
 *                 Map.entry("suffix", "test_suffix")
 *             ))
 *             .defaultDataLakeStoreAccount("test_adls")
 *             .firewallAllowAzureIps("Enabled")
 *             .firewallRules(Map.ofEntries(
 *                 Map.entry("endIpAddress", "2.2.2.2"),
 *                 Map.entry("name", "test_rule"),
 *                 Map.entry("startIpAddress", "1.1.1.1")
 *             ))
 *             .firewallState("Enabled")
 *             .location("eastus2")
 *             .maxDegreeOfParallelism(30)
 *             .maxDegreeOfParallelismPerJob(1)
 *             .maxJobCount(3)
 *             .minPriorityPerJob(1)
 *             .newTier("Consumption")
 *             .queryStoreRetention(30)
 *             .resourceGroupName("contosorg")
 *             .storageAccounts(Map.ofEntries(
 *                 Map.entry("accessKey", "34adfa4f-cedf-4dc0-ba29-b6d1a69ab346"),
 *                 Map.entry("name", "test_storage"),
 *                 Map.entry("suffix", "test_suffix")
 *             ))
 *             .tags(Map.of("test_key", "test_value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakeanalytics:Account test_account /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}
 * ```
 * @property accountName The name of the Data Lake Analytics account.
 * @property computePolicies The list of compute policies associated with this account.
 * @property dataLakeStoreAccounts The list of Data Lake Store accounts associated with this account.
 * @property defaultDataLakeStoreAccount The default Data Lake Store account associated with this account.
 * @property firewallAllowAzureIps The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
 * @property firewallRules The list of firewall rules associated with this account.
 * @property firewallState The current state of the IP address firewall for this account.
 * @property location The resource location.
 * @property maxDegreeOfParallelism The maximum supported degree of parallelism for this account.
 * @property maxDegreeOfParallelismPerJob The maximum supported degree of parallelism per job for this account.
 * @property maxJobCount The maximum supported jobs running under the account at the same time.
 * @property minPriorityPerJob The minimum supported priority per job for this account.
 * @property newTier The commitment tier for the next month.
 * @property queryStoreRetention The number of days that job metadata is retained.
 * @property resourceGroupName The name of the Azure resource group.
 * @property storageAccounts The list of Azure Blob Storage accounts associated with this account.
 * @property tags The resource tags.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val computePolicies: Output<List<CreateComputePolicyWithAccountParametersArgs>>? = null,
    public val dataLakeStoreAccounts: Output<List<AddDataLakeStoreWithAccountParametersArgs>>? = null,
    public val defaultDataLakeStoreAccount: Output<String>? = null,
    public val firewallAllowAzureIps: Output<FirewallAllowAzureIpsState>? = null,
    public val firewallRules: Output<List<CreateFirewallRuleWithAccountParametersArgs>>? = null,
    public val firewallState: Output<FirewallState>? = null,
    public val location: Output<String>? = null,
    public val maxDegreeOfParallelism: Output<Int>? = null,
    public val maxDegreeOfParallelismPerJob: Output<Int>? = null,
    public val maxJobCount: Output<Int>? = null,
    public val minPriorityPerJob: Output<Int>? = null,
    public val newTier: Output<TierType>? = null,
    public val queryStoreRetention: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccounts: Output<List<AddStorageAccountWithAccountParametersArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakeanalytics.AccountArgs =
        com.pulumi.azurenative.datalakeanalytics.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .computePolicies(
                computePolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataLakeStoreAccounts(
                dataLakeStoreAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultDataLakeStoreAccount(defaultDataLakeStoreAccount?.applyValue({ args0 -> args0 }))
            .firewallAllowAzureIps(
                firewallAllowAzureIps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .firewallRules(
                firewallRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .firewallState(firewallState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maxDegreeOfParallelism(maxDegreeOfParallelism?.applyValue({ args0 -> args0 }))
            .maxDegreeOfParallelismPerJob(maxDegreeOfParallelismPerJob?.applyValue({ args0 -> args0 }))
            .maxJobCount(maxJobCount?.applyValue({ args0 -> args0 }))
            .minPriorityPerJob(minPriorityPerJob?.applyValue({ args0 -> args0 }))
            .newTier(newTier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryStoreRetention(queryStoreRetention?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccounts(
                storageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var computePolicies: Output<List<CreateComputePolicyWithAccountParametersArgs>>? = null

    private var dataLakeStoreAccounts: Output<List<AddDataLakeStoreWithAccountParametersArgs>>? = null

    private var defaultDataLakeStoreAccount: Output<String>? = null

    private var firewallAllowAzureIps: Output<FirewallAllowAzureIpsState>? = null

    private var firewallRules: Output<List<CreateFirewallRuleWithAccountParametersArgs>>? = null

    private var firewallState: Output<FirewallState>? = null

    private var location: Output<String>? = null

    private var maxDegreeOfParallelism: Output<Int>? = null

    private var maxDegreeOfParallelismPerJob: Output<Int>? = null

    private var maxJobCount: Output<Int>? = null

    private var minPriorityPerJob: Output<Int>? = null

    private var newTier: Output<TierType>? = null

    private var queryStoreRetention: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccounts: Output<List<AddStorageAccountWithAccountParametersArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Data Lake Analytics account.
     */
    @JvmName("dxbtoenusxqdewyx")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The list of compute policies associated with this account.
     */
    @JvmName("uftxeavdjcwgjwli")
    public suspend
    fun computePolicies(`value`: Output<List<CreateComputePolicyWithAccountParametersArgs>>) {
        this.computePolicies = value
    }

    @JvmName("hiiojlirpnduaybh")
    public suspend fun computePolicies(
        vararg
        values: Output<CreateComputePolicyWithAccountParametersArgs>,
    ) {
        this.computePolicies = Output.all(values.asList())
    }

    /**
     * @param values The list of compute policies associated with this account.
     */
    @JvmName("utmafcecujsfjrpr")
    public suspend
    fun computePolicies(values: List<Output<CreateComputePolicyWithAccountParametersArgs>>) {
        this.computePolicies = Output.all(values)
    }

    /**
     * @param value The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("jrinairaeyifobjr")
    public suspend
    fun dataLakeStoreAccounts(`value`: Output<List<AddDataLakeStoreWithAccountParametersArgs>>) {
        this.dataLakeStoreAccounts = value
    }

    @JvmName("nnohmqwpahejbdry")
    public suspend fun dataLakeStoreAccounts(
        vararg
        values: Output<AddDataLakeStoreWithAccountParametersArgs>,
    ) {
        this.dataLakeStoreAccounts = Output.all(values.asList())
    }

    /**
     * @param values The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("jqhajsrdliicvhjc")
    public suspend
    fun dataLakeStoreAccounts(values: List<Output<AddDataLakeStoreWithAccountParametersArgs>>) {
        this.dataLakeStoreAccounts = Output.all(values)
    }

    /**
     * @param value The default Data Lake Store account associated with this account.
     */
    @JvmName("solcgskpishkrtds")
    public suspend fun defaultDataLakeStoreAccount(`value`: Output<String>) {
        this.defaultDataLakeStoreAccount = value
    }

    /**
     * @param value The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
     */
    @JvmName("oegcslwxgoasbind")
    public suspend fun firewallAllowAzureIps(`value`: Output<FirewallAllowAzureIpsState>) {
        this.firewallAllowAzureIps = value
    }

    /**
     * @param value The list of firewall rules associated with this account.
     */
    @JvmName("paurpiafehahrbxm")
    public suspend
    fun firewallRules(`value`: Output<List<CreateFirewallRuleWithAccountParametersArgs>>) {
        this.firewallRules = value
    }

    @JvmName("lkolugfpvbjjxhjs")
    public suspend fun firewallRules(
        vararg
        values: Output<CreateFirewallRuleWithAccountParametersArgs>,
    ) {
        this.firewallRules = Output.all(values.asList())
    }

    /**
     * @param values The list of firewall rules associated with this account.
     */
    @JvmName("fpdpfmejiakbywgm")
    public suspend
    fun firewallRules(values: List<Output<CreateFirewallRuleWithAccountParametersArgs>>) {
        this.firewallRules = Output.all(values)
    }

    /**
     * @param value The current state of the IP address firewall for this account.
     */
    @JvmName("ftsegkaqymxiwscj")
    public suspend fun firewallState(`value`: Output<FirewallState>) {
        this.firewallState = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("irpclyjrsyfkffes")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maximum supported degree of parallelism for this account.
     */
    @JvmName("pdypglerplboivsj")
    public suspend fun maxDegreeOfParallelism(`value`: Output<Int>) {
        this.maxDegreeOfParallelism = value
    }

    /**
     * @param value The maximum supported degree of parallelism per job for this account.
     */
    @JvmName("utcbrpnvteigfspl")
    public suspend fun maxDegreeOfParallelismPerJob(`value`: Output<Int>) {
        this.maxDegreeOfParallelismPerJob = value
    }

    /**
     * @param value The maximum supported jobs running under the account at the same time.
     */
    @JvmName("cqgtaoyeqxsgmywu")
    public suspend fun maxJobCount(`value`: Output<Int>) {
        this.maxJobCount = value
    }

    /**
     * @param value The minimum supported priority per job for this account.
     */
    @JvmName("bfenjibvhipvtiqs")
    public suspend fun minPriorityPerJob(`value`: Output<Int>) {
        this.minPriorityPerJob = value
    }

    /**
     * @param value The commitment tier for the next month.
     */
    @JvmName("sgywipwhnamirkqh")
    public suspend fun newTier(`value`: Output<TierType>) {
        this.newTier = value
    }

    /**
     * @param value The number of days that job metadata is retained.
     */
    @JvmName("dsxigtkwwjqsooer")
    public suspend fun queryStoreRetention(`value`: Output<Int>) {
        this.queryStoreRetention = value
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("brkmhymmxvgydjil")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("cjaskmoifldjdlaw")
    public suspend
    fun storageAccounts(`value`: Output<List<AddStorageAccountWithAccountParametersArgs>>) {
        this.storageAccounts = value
    }

    @JvmName("qalobupfxlgommea")
    public suspend fun storageAccounts(
        vararg
        values: Output<AddStorageAccountWithAccountParametersArgs>,
    ) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("fdgolguqotaqxrfv")
    public suspend
    fun storageAccounts(values: List<Output<AddStorageAccountWithAccountParametersArgs>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("lummqgyatgftvpjr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Data Lake Analytics account.
     */
    @JvmName("fapforyeptlvjrqu")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The list of compute policies associated with this account.
     */
    @JvmName("xvlxxlitxyshuxus")
    public suspend fun computePolicies(`value`: List<CreateComputePolicyWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computePolicies = mapped
    }

    /**
     * @param argument The list of compute policies associated with this account.
     */
    @JvmName("alrlcjwbsdeotygi")
    public suspend
    fun computePolicies(argument: List<suspend CreateComputePolicyWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CreateComputePolicyWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computePolicies = mapped
    }

    /**
     * @param argument The list of compute policies associated with this account.
     */
    @JvmName("uaxcvldugrqjdvpi")
    public suspend fun computePolicies(
        vararg
        argument: suspend CreateComputePolicyWithAccountParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CreateComputePolicyWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computePolicies = mapped
    }

    /**
     * @param argument The list of compute policies associated with this account.
     */
    @JvmName("gvbsragytxjbmmqr")
    public suspend
    fun computePolicies(argument: suspend CreateComputePolicyWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CreateComputePolicyWithAccountParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.computePolicies = mapped
    }

    /**
     * @param values The list of compute policies associated with this account.
     */
    @JvmName("xxsucwmmshymyowu")
    public suspend fun computePolicies(vararg values: CreateComputePolicyWithAccountParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computePolicies = mapped
    }

    /**
     * @param value The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("uigpouqpnwtaotyg")
    public suspend
    fun dataLakeStoreAccounts(`value`: List<AddDataLakeStoreWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeStoreAccounts = mapped
    }

    /**
     * @param argument The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("cuaqbeuuqdkqgtfb")
    public suspend
    fun dataLakeStoreAccounts(argument: List<suspend AddDataLakeStoreWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddDataLakeStoreWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataLakeStoreAccounts = mapped
    }

    /**
     * @param argument The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("ucpfdpoefwkgmfoq")
    public suspend fun dataLakeStoreAccounts(
        vararg
        argument: suspend AddDataLakeStoreWithAccountParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AddDataLakeStoreWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataLakeStoreAccounts = mapped
    }

    /**
     * @param argument The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("htqpuqyoxmvrabbu")
    public suspend
    fun dataLakeStoreAccounts(argument: suspend AddDataLakeStoreWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AddDataLakeStoreWithAccountParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataLakeStoreAccounts = mapped
    }

    /**
     * @param values The list of Data Lake Store accounts associated with this account.
     */
    @JvmName("odqustkcowdjrayr")
    public suspend fun dataLakeStoreAccounts(
        vararg
        values: AddDataLakeStoreWithAccountParametersArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataLakeStoreAccounts = mapped
    }

    /**
     * @param value The default Data Lake Store account associated with this account.
     */
    @JvmName("agwmqmckxdbwybes")
    public suspend fun defaultDataLakeStoreAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDataLakeStoreAccount = mapped
    }

    /**
     * @param value The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
     */
    @JvmName("vqgjjmcgfalwasak")
    public suspend fun firewallAllowAzureIps(`value`: FirewallAllowAzureIpsState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallAllowAzureIps = mapped
    }

    /**
     * @param value The list of firewall rules associated with this account.
     */
    @JvmName("kbfsqrwvhvlokplt")
    public suspend fun firewallRules(`value`: List<CreateFirewallRuleWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param argument The list of firewall rules associated with this account.
     */
    @JvmName("ubngjvitxkbvfoit")
    public suspend
    fun firewallRules(argument: List<suspend CreateFirewallRuleWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CreateFirewallRuleWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument The list of firewall rules associated with this account.
     */
    @JvmName("eepkiofvbbqywqkp")
    public suspend fun firewallRules(
        vararg
        argument: suspend CreateFirewallRuleWithAccountParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CreateFirewallRuleWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument The list of firewall rules associated with this account.
     */
    @JvmName("msaivqtukpcepwvl")
    public suspend
    fun firewallRules(argument: suspend CreateFirewallRuleWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CreateFirewallRuleWithAccountParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param values The list of firewall rules associated with this account.
     */
    @JvmName("ahmnvtutwocfbodm")
    public suspend fun firewallRules(vararg values: CreateFirewallRuleWithAccountParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param value The current state of the IP address firewall for this account.
     */
    @JvmName("hrlngdpkavwafsdg")
    public suspend fun firewallState(`value`: FirewallState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallState = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("yexkdoanmpajusrp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maximum supported degree of parallelism for this account.
     */
    @JvmName("rujsucbaidlnqxym")
    public suspend fun maxDegreeOfParallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDegreeOfParallelism = mapped
    }

    /**
     * @param value The maximum supported degree of parallelism per job for this account.
     */
    @JvmName("ijicfaaqaeypwjsa")
    public suspend fun maxDegreeOfParallelismPerJob(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDegreeOfParallelismPerJob = mapped
    }

    /**
     * @param value The maximum supported jobs running under the account at the same time.
     */
    @JvmName("nljbxnlwcxnfgwxi")
    public suspend fun maxJobCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxJobCount = mapped
    }

    /**
     * @param value The minimum supported priority per job for this account.
     */
    @JvmName("eqotjouiglhqihot")
    public suspend fun minPriorityPerJob(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPriorityPerJob = mapped
    }

    /**
     * @param value The commitment tier for the next month.
     */
    @JvmName("fnycrlftcpbbcaqh")
    public suspend fun newTier(`value`: TierType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newTier = mapped
    }

    /**
     * @param value The number of days that job metadata is retained.
     */
    @JvmName("yspiknoqigbvymtu")
    public suspend fun queryStoreRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStoreRetention = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("flmvfwnkveucagrw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("pltmgnvyytgmklex")
    public suspend fun storageAccounts(`value`: List<AddStorageAccountWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param argument The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("jdpfwvtsnxsuwcup")
    public suspend
    fun storageAccounts(argument: List<suspend AddStorageAccountWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddStorageAccountWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("pvfcmqlludifsqcg")
    public suspend fun storageAccounts(
        vararg
        argument: suspend AddStorageAccountWithAccountParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AddStorageAccountWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("ukqvydnmdcgppjwh")
    public suspend
    fun storageAccounts(argument: suspend AddStorageAccountWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AddStorageAccountWithAccountParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param values The list of Azure Blob Storage accounts associated with this account.
     */
    @JvmName("gxpgjglltvskyfnr")
    public suspend fun storageAccounts(vararg values: AddStorageAccountWithAccountParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("cwgmxuoferdfgkia")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("angslcjatbvggxoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        computePolicies = computePolicies,
        dataLakeStoreAccounts = dataLakeStoreAccounts,
        defaultDataLakeStoreAccount = defaultDataLakeStoreAccount,
        firewallAllowAzureIps = firewallAllowAzureIps,
        firewallRules = firewallRules,
        firewallState = firewallState,
        location = location,
        maxDegreeOfParallelism = maxDegreeOfParallelism,
        maxDegreeOfParallelismPerJob = maxDegreeOfParallelismPerJob,
        maxJobCount = maxJobCount,
        minPriorityPerJob = minPriorityPerJob,
        newTier = newTier,
        queryStoreRetention = queryStoreRetention,
        resourceGroupName = resourceGroupName,
        storageAccounts = storageAccounts,
        tags = tags,
    )
}
