@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin

import com.pulumi.azurenative.datalakeanalytics.DatalakeanalyticsFunctions.getAccountPlain
import com.pulumi.azurenative.datalakeanalytics.DatalakeanalyticsFunctions.getComputePolicyPlain
import com.pulumi.azurenative.datalakeanalytics.DatalakeanalyticsFunctions.getFirewallRulePlain
import com.pulumi.azurenative.datalakeanalytics.DatalakeanalyticsFunctions.listStorageAccountSasTokensPlain
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.GetComputePolicyPlainArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.GetComputePolicyPlainArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.GetFirewallRulePlainArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.GetFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.ListStorageAccountSasTokensPlainArgs
import com.pulumi.azurenative.datalakeanalytics.kotlin.inputs.ListStorageAccountSasTokensPlainArgsBuilder
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.GetComputePolicyResult
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.GetFirewallRuleResult
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.ListStorageAccountSasTokensResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.GetComputePolicyResult.Companion.toKotlin as getComputePolicyResultToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.GetFirewallRuleResult.Companion.toKotlin as getFirewallRuleResultToKotlin
import com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.ListStorageAccountSasTokensResult.Companion.toKotlin as listStorageAccountSasTokensResultToKotlin

public object DatalakeanalyticsFunctions {
    /**
     * Gets details of the specified Data Lake Analytics account.
     * Azure REST API version: 2019-11-01-preview.
     * Other available API versions: 2015-10-01-preview.
     * @param argument null
     * @return A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the Data Lake Analytics account.
     * @param resourceGroupName The name of the Azure resource group.
     * @return A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datalakeanalytics&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Data Lake Analytics compute policy.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return Data Lake Analytics compute policy information.
     */
    public suspend fun getComputePolicy(argument: GetComputePolicyPlainArgs): GetComputePolicyResult =
        getComputePolicyResultToKotlin(getComputePolicyPlain(argument.toJava()).await())

    /**
     * @see [getComputePolicy].
     * @param accountName The name of the Data Lake Analytics account.
     * @param computePolicyName The name of the compute policy to retrieve.
     * @param resourceGroupName The name of the Azure resource group.
     * @return Data Lake Analytics compute policy information.
     */
    public suspend fun getComputePolicy(
        accountName: String,
        computePolicyName: String,
        resourceGroupName: String,
    ): GetComputePolicyResult {
        val argument = GetComputePolicyPlainArgs(
            accountName = accountName,
            computePolicyName = computePolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getComputePolicyResultToKotlin(getComputePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getComputePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datalakeanalytics&#46;kotlin&#46;inputs&#46;GetComputePolicyPlainArgs].
     * @return Data Lake Analytics compute policy information.
     */
    public suspend
    fun getComputePolicy(argument: suspend GetComputePolicyPlainArgsBuilder.() -> Unit):
        GetComputePolicyResult {
        val builder = GetComputePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComputePolicyResultToKotlin(getComputePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Data Lake Analytics firewall rule.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return Data Lake Analytics firewall rule information.
     */
    public suspend fun getFirewallRule(argument: GetFirewallRulePlainArgs): GetFirewallRuleResult =
        getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getFirewallRule].
     * @param accountName The name of the Data Lake Analytics account.
     * @param firewallRuleName The name of the firewall rule to retrieve.
     * @param resourceGroupName The name of the Azure resource group.
     * @return Data Lake Analytics firewall rule information.
     */
    public suspend fun getFirewallRule(
        accountName: String,
        firewallRuleName: String,
        resourceGroupName: String,
    ): GetFirewallRuleResult {
        val argument = GetFirewallRulePlainArgs(
            accountName = accountName,
            firewallRuleName = firewallRuleName,
            resourceGroupName = resourceGroupName,
        )
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datalakeanalytics&#46;kotlin&#46;inputs&#46;GetFirewallRulePlainArgs].
     * @return Data Lake Analytics firewall rule information.
     */
    public suspend fun getFirewallRule(argument: suspend GetFirewallRulePlainArgsBuilder.() -> Unit):
        GetFirewallRuleResult {
        val builder = GetFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SAS token associated with the specified Data Lake Analytics and Azure Storage account and container combination.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return The SAS response that contains the storage account, container and associated SAS token for connection use.
     */
    public suspend fun listStorageAccountSasTokens(argument: ListStorageAccountSasTokensPlainArgs):
        ListStorageAccountSasTokensResult =
        listStorageAccountSasTokensResultToKotlin(listStorageAccountSasTokensPlain(argument.toJava()).await())

    /**
     * @see [listStorageAccountSasTokens].
     * @param accountName The name of the Data Lake Analytics account.
     * @param containerName The name of the Azure storage container for which the SAS token is being requested.
     * @param resourceGroupName The name of the Azure resource group.
     * @param storageAccountName The name of the Azure storage account for which the SAS token is being requested.
     * @return The SAS response that contains the storage account, container and associated SAS token for connection use.
     */
    public suspend fun listStorageAccountSasTokens(
        accountName: String,
        containerName: String,
        resourceGroupName: String,
        storageAccountName: String,
    ): ListStorageAccountSasTokensResult {
        val argument = ListStorageAccountSasTokensPlainArgs(
            accountName = accountName,
            containerName = containerName,
            resourceGroupName = resourceGroupName,
            storageAccountName = storageAccountName,
        )
        return listStorageAccountSasTokensResultToKotlin(listStorageAccountSasTokensPlain(argument.toJava()).await())
    }

    /**
     * @see [listStorageAccountSasTokens].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datalakeanalytics&#46;kotlin&#46;inputs&#46;ListStorageAccountSasTokensPlainArgs].
     * @return The SAS response that contains the storage account, container and associated SAS token for connection use.
     */
    public suspend
    fun listStorageAccountSasTokens(argument: suspend ListStorageAccountSasTokensPlainArgsBuilder.() -> Unit):
        ListStorageAccountSasTokensResult {
        val builder = ListStorageAccountSasTokensPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listStorageAccountSasTokensResultToKotlin(listStorageAccountSasTokensPlain(builtArgument.toJava()).await())
    }
}
