@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.inputs

import com.pulumi.azurenative.datalakeanalytics.inputs.CreateComputePolicyWithAccountParametersArgs.builder
import com.pulumi.azurenative.datalakeanalytics.kotlin.enums.AADObjectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters used to create a new compute policy while creating a new Data Lake Analytics account.
 * @property maxDegreeOfParallelismPerJob The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
 * @property minPriorityPerJob The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
 * @property name The unique name of the compute policy to create.
 * @property objectId The AAD object identifier for the entity to create a policy for.
 * @property objectType The type of AAD object the object identifier refers to.
 */
public data class CreateComputePolicyWithAccountParametersArgs(
    public val maxDegreeOfParallelismPerJob: Output<Int>? = null,
    public val minPriorityPerJob: Output<Int>? = null,
    public val name: Output<String>,
    public val objectId: Output<String>,
    public val objectType: Output<Either<String, AADObjectType>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.inputs.CreateComputePolicyWithAccountParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.datalakeanalytics.inputs.CreateComputePolicyWithAccountParametersArgs =
        com.pulumi.azurenative.datalakeanalytics.inputs.CreateComputePolicyWithAccountParametersArgs.builder()
            .maxDegreeOfParallelismPerJob(maxDegreeOfParallelismPerJob?.applyValue({ args0 -> args0 }))
            .minPriorityPerJob(minPriorityPerJob?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .objectId(objectId.applyValue({ args0 -> args0 }))
            .objectType(
                objectType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CreateComputePolicyWithAccountParametersArgs].
 */
@PulumiTagMarker
public class CreateComputePolicyWithAccountParametersArgsBuilder internal constructor() {
    private var maxDegreeOfParallelismPerJob: Output<Int>? = null

    private var minPriorityPerJob: Output<Int>? = null

    private var name: Output<String>? = null

    private var objectId: Output<String>? = null

    private var objectType: Output<Either<String, AADObjectType>>? = null

    /**
     * @param value The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
     */
    @JvmName("oingawoklvqmpgeu")
    public suspend fun maxDegreeOfParallelismPerJob(`value`: Output<Int>) {
        this.maxDegreeOfParallelismPerJob = value
    }

    /**
     * @param value The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
     */
    @JvmName("xxtljipgrqxxdctp")
    public suspend fun minPriorityPerJob(`value`: Output<Int>) {
        this.minPriorityPerJob = value
    }

    /**
     * @param value The unique name of the compute policy to create.
     */
    @JvmName("eloyxnxfjavetlii")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The AAD object identifier for the entity to create a policy for.
     */
    @JvmName("rotmvlddewivhncb")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("fibhqairvkunnjep")
    public suspend fun objectType(`value`: Output<Either<String, AADObjectType>>) {
        this.objectType = value
    }

    /**
     * @param value The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
     */
    @JvmName("blolkjsxgrtlliet")
    public suspend fun maxDegreeOfParallelismPerJob(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDegreeOfParallelismPerJob = mapped
    }

    /**
     * @param value The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
     */
    @JvmName("fchngitdvvjnmoow")
    public suspend fun minPriorityPerJob(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPriorityPerJob = mapped
    }

    /**
     * @param value The unique name of the compute policy to create.
     */
    @JvmName("mepsgagvsrlpkdpf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The AAD object identifier for the entity to create a policy for.
     */
    @JvmName("srowxxuuabtumqms")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("svixwifimcvedpct")
    public suspend fun objectType(`value`: Either<String, AADObjectType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("xopqmiliiiqyptcd")
    public fun objectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AADObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("ichtldgcydnmaypi")
    public fun objectType(`value`: AADObjectType) {
        val toBeMapped = Either.ofRight<String, AADObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): CreateComputePolicyWithAccountParametersArgs =
        CreateComputePolicyWithAccountParametersArgs(
            maxDegreeOfParallelismPerJob = maxDegreeOfParallelismPerJob,
            minPriorityPerJob = minPriorityPerJob,
            name = name ?: throw PulumiNullFieldException("name"),
            objectId = objectId ?: throw PulumiNullFieldException("objectId"),
            objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        )
}
