@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data Lake Analytics  VirtualNetwork Rule information.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property subnetId The resource identifier for the subnet
 * @property type The resource type.
 * @property virtualNetworkRuleState The current state of the VirtualNetwork Rule
 */
public data class VirtualNetworkRuleResponse(
    public val id: String,
    public val name: String,
    public val subnetId: String,
    public val type: String,
    public val virtualNetworkRuleState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.outputs.VirtualNetworkRuleResponse):
            VirtualNetworkRuleResponse = VirtualNetworkRuleResponse(
            id = javaType.id(),
            name = javaType.name(),
            subnetId = javaType.subnetId(),
            type = javaType.type(),
            virtualNetworkRuleState = javaType.virtualNetworkRuleState(),
        )
    }
}
