@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FirewallRule].
 */
@PulumiTagMarker
public class FirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallRuleArgs = FirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val builder = FirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FirewallRule {
        val builtJavaResource =
            com.pulumi.azurenative.datalakestore.FirewallRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallRule(builtJavaResource)
    }
}

/**
 * Data Lake Store firewall rule information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified firewall rule. During update, the firewall rule with the specified name will be replaced with this new firewall rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.DataLakeStore.FirewallRule("firewallRule", new()
 *     {
 *         AccountName = "contosoadla",
 *         EndIpAddress = "2.2.2.2",
 *         FirewallRuleName = "test_rule",
 *         ResourceGroupName = "contosorg",
 *         StartIpAddress = "1.1.1.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewFirewallRule(ctx, "firewallRule", &datalakestore.FirewallRuleArgs{
 * 			AccountName:       pulumi.String("contosoadla"),
 * 			EndIpAddress:      pulumi.String("2.2.2.2"),
 * 			FirewallRuleName:  pulumi.String("test_rule"),
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			StartIpAddress:    pulumi.String("1.1.1.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.FirewallRule;
 * import com.pulumi.azurenative.datalakestore.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .accountName("contosoadla")
 *             .endIpAddress("2.2.2.2")
 *             .firewallRuleName("test_rule")
 *             .resourceGroupName("contosorg")
 *             .startIpAddress("1.1.1.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:FirewallRule test_rule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}
 * ```
 */
public class FirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.datalakestore.FirewallRule,
) : KotlinCustomResource(javaResource, FirewallRuleMapper) {
    /**
     * The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    public val endIpAddress: Output<String>
        get() = javaResource.endIpAddress().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    public val startIpAddress: Output<String>
        get() = javaResource.startIpAddress().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallRuleMapper : ResourceMapper<FirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datalakestore.FirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): FirewallRule = FirewallRule(
        javaResource as
            com.pulumi.azurenative.datalakestore.FirewallRule,
    )
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallRule].
 */
public suspend fun firewallRule(
    name: String,
    block: suspend FirewallRuleResourceBuilder.() -> Unit,
): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallRule(name: String): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
