@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.azurenative.datalakestore.FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data Lake Store firewall rule information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified firewall rule. During update, the firewall rule with the specified name will be replaced with this new firewall rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.DataLakeStore.FirewallRule("firewallRule", new()
 *     {
 *         AccountName = "contosoadla",
 *         EndIpAddress = "2.2.2.2",
 *         FirewallRuleName = "test_rule",
 *         ResourceGroupName = "contosorg",
 *         StartIpAddress = "1.1.1.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewFirewallRule(ctx, "firewallRule", &datalakestore.FirewallRuleArgs{
 * 			AccountName:       pulumi.String("contosoadla"),
 * 			EndIpAddress:      pulumi.String("2.2.2.2"),
 * 			FirewallRuleName:  pulumi.String("test_rule"),
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			StartIpAddress:    pulumi.String("1.1.1.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.FirewallRule;
 * import com.pulumi.azurenative.datalakestore.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .accountName("contosoadla")
 *             .endIpAddress("2.2.2.2")
 *             .firewallRuleName("test_rule")
 *             .resourceGroupName("contosorg")
 *             .startIpAddress("1.1.1.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:FirewallRule test_rule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}
 * ```
 * @property accountName The name of the Data Lake Store account.
 * @property endIpAddress The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
 * @property firewallRuleName The name of the firewall rule to create or update.
 * @property resourceGroupName The name of the Azure resource group.
 * @property startIpAddress The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
 */
public data class FirewallRuleArgs(
    public val accountName: Output<String>? = null,
    public val endIpAddress: Output<String>? = null,
    public val firewallRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val startIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.FirewallRuleArgs =
        com.pulumi.azurenative.datalakestore.FirewallRuleArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .endIpAddress(endIpAddress?.applyValue({ args0 -> args0 }))
            .firewallRuleName(firewallRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallRuleArgs].
 */
@PulumiTagMarker
public class FirewallRuleArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var endIpAddress: Output<String>? = null

    private var firewallRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("wbeixgpvbbuhlllf")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("lhrfchkfhgsfefsk")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value The name of the firewall rule to create or update.
     */
    @JvmName("gvhmavlnvtoimqur")
    public suspend fun firewallRuleName(`value`: Output<String>) {
        this.firewallRuleName = value
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("gmcmfscbmwlkocjb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("hdbgaxutpkelghcv")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("junyhjrgilhebspd")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("xqwwefqlmrxeqein")
    public suspend fun endIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value The name of the firewall rule to create or update.
     */
    @JvmName("lmnxhgfnwfrqkvqk")
    public suspend fun firewallRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("jwmoyifmqfcqkypl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("cifrnipmocaupixx")
    public suspend fun startIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    internal fun build(): FirewallRuleArgs = FirewallRuleArgs(
        accountName = accountName,
        endIpAddress = endIpAddress,
        firewallRuleName = firewallRuleName,
        resourceGroupName = resourceGroupName,
        startIpAddress = startIpAddress,
    )
}
