@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.azurenative.datalakestore.VirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data Lake Store virtual network rule information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified virtual network rule. During update, the virtual network rule with the specified name will be replaced with this new virtual network rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkRule = new AzureNative.DataLakeStore.VirtualNetworkRule("virtualNetworkRule", new()
 *     {
 *         AccountName = "contosoadla",
 *         ResourceGroupName = "contosorg",
 *         SubnetId = "test_subnetId",
 *         VirtualNetworkRuleName = "test_virtual_network_rules_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewVirtualNetworkRule(ctx, "virtualNetworkRule", &datalakestore.VirtualNetworkRuleArgs{
 * 			AccountName:            pulumi.String("contosoadla"),
 * 			ResourceGroupName:      pulumi.String("contosorg"),
 * 			SubnetId:               pulumi.String("test_subnetId"),
 * 			VirtualNetworkRuleName: pulumi.String("test_virtual_network_rules_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.VirtualNetworkRule;
 * import com.pulumi.azurenative.datalakestore.VirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkRule = new VirtualNetworkRule("virtualNetworkRule", VirtualNetworkRuleArgs.builder()
 *             .accountName("contosoadla")
 *             .resourceGroupName("contosorg")
 *             .subnetId("test_subnetId")
 *             .virtualNetworkRuleName("test_virtual_network_rules_name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:VirtualNetworkRule test_virtual_network_rules_name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules/{virtualNetworkRuleName}
 * ```
 * @property accountName The name of the Data Lake Store account.
 * @property resourceGroupName The name of the Azure resource group.
 * @property subnetId The resource identifier for the subnet.
 * @property virtualNetworkRuleName The name of the virtual network rule to create or update.
 */
public data class VirtualNetworkRuleArgs(
    public val accountName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val virtualNetworkRuleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.datalakestore.VirtualNetworkRuleArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .virtualNetworkRuleName(virtualNetworkRuleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var virtualNetworkRuleName: Output<String>? = null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("ythobjcppfebhcyt")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("krdaqsdtetqwxusr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource identifier for the subnet.
     */
    @JvmName("bawwdtbyijbxxyup")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The name of the virtual network rule to create or update.
     */
    @JvmName("rhcjeqcmpphbpacb")
    public suspend fun virtualNetworkRuleName(`value`: Output<String>) {
        this.virtualNetworkRuleName = value
    }

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("rhrruanvvypjornj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("lqjgmlhfbthyoupg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource identifier for the subnet.
     */
    @JvmName("jkntwpnwrikvhwpb")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The name of the virtual network rule to create or update.
     */
    @JvmName("fomtjskdyhadudnx")
    public suspend fun virtualNetworkRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRuleName = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        accountName = accountName,
        resourceGroupName = resourceGroupName,
        subnetId = subnetId,
        virtualNetworkRuleName = virtualNetworkRuleName,
    )
}
