@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.GetTrustedIdProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Data Lake Store account.
 * @property resourceGroupName The name of the Azure resource group.
 * @property trustedIdProviderName The name of the trusted identity provider to retrieve.
 */
public data class GetTrustedIdProviderPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val trustedIdProviderName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.GetTrustedIdProviderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.inputs.GetTrustedIdProviderPlainArgs =
        com.pulumi.azurenative.datalakestore.inputs.GetTrustedIdProviderPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .trustedIdProviderName(trustedIdProviderName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrustedIdProviderPlainArgs].
 */
@PulumiTagMarker
public class GetTrustedIdProviderPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var trustedIdProviderName: String? = null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("qlvoyjphdiwvryfc")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("rxkuaevvgmcpyhga")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the trusted identity provider to retrieve.
     */
    @JvmName("sdeduhtnrchkacuy")
    public suspend fun trustedIdProviderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trustedIdProviderName = mapped
    }

    internal fun build(): GetTrustedIdProviderPlainArgs = GetTrustedIdProviderPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        trustedIdProviderName = trustedIdProviderName ?: throw
            PulumiNullFieldException("trustedIdProviderName"),
    )
}
