@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.FileArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.inputs.ProjectFilePropertiesArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.ProjectFilePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A file resource
 * Azure REST API version: 2021-06-30. Prior API version in Azure Native 1.x: 2018-07-15-preview.
 * Other available API versions: 2022-03-30-preview.
 * ## Example Usage
 * ### Files_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var file = new AzureNative.DataMigration.File("file", new()
 *     {
 *         FileName = "x114d023d8",
 *         GroupName = "DmsSdkRg",
 *         ProjectName = "DmsSdkProject",
 *         Properties = new AzureNative.DataMigration.Inputs.ProjectFilePropertiesArgs
 *         {
 *             FilePath = "DmsSdkFilePath/DmsSdkFile.sql",
 *         },
 *         ServiceName = "DmsSdkService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewFile(ctx, "file", &datamigration.FileArgs{
 * 			FileName:    pulumi.String("x114d023d8"),
 * 			GroupName:   pulumi.String("DmsSdkRg"),
 * 			ProjectName: pulumi.String("DmsSdkProject"),
 * 			Properties: &datamigration.ProjectFilePropertiesArgs{
 * 				FilePath: pulumi.String("DmsSdkFilePath/DmsSdkFile.sql"),
 * 			},
 * 			ServiceName: pulumi.String("DmsSdkService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.File;
 * import com.pulumi.azurenative.datamigration.FileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var file = new File("file", FileArgs.builder()
 *             .fileName("x114d023d8")
 *             .groupName("DmsSdkRg")
 *             .projectName("DmsSdkProject")
 *             .properties(Map.of("filePath", "DmsSdkFilePath/DmsSdkFile.sql"))
 *             .serviceName("DmsSdkService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:File x114d023d8 /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}
 * ```
 * @property fileName Name of the File
 * @property groupName Name of the resource group
 * @property projectName Name of the project
 * @property properties Custom file properties
 * @property serviceName Name of the service
 */
public data class FileArgs(
    public val fileName: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<ProjectFilePropertiesArgs>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.FileArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.FileArgs =
        com.pulumi.azurenative.datamigration.FileArgs.builder()
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileArgs].
 */
@PulumiTagMarker
public class FileArgsBuilder internal constructor() {
    private var fileName: Output<String>? = null

    private var groupName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<ProjectFilePropertiesArgs>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Name of the File
     */
    @JvmName("uplmtgmelqhngipc")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("tcebngqydrbjixky")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Name of the project
     */
    @JvmName("qibnbhththehaaox")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Custom file properties
     */
    @JvmName("dtbopfeiycvotvsj")
    public suspend fun properties(`value`: Output<ProjectFilePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the service
     */
    @JvmName("rkwkkfrgulydwpob")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Name of the File
     */
    @JvmName("wbmrnyaxemvqxtke")
    public suspend fun fileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("qtprxgjeniapwghf")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Name of the project
     */
    @JvmName("gfjjdvfkdtynkxuj")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Custom file properties
     */
    @JvmName("xfhbeswqboqfpunl")
    public suspend fun properties(`value`: ProjectFilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Custom file properties
     */
    @JvmName("oohwqjqueninenyf")
    public suspend fun properties(argument: suspend ProjectFilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectFilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("cmkymcsbcmgmascw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): FileArgs = FileArgs(
        fileName = fileName,
        groupName = groupName,
        projectName = projectName,
        properties = properties,
        serviceName = serviceName,
    )
}
