@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Backup Mode to specify whether to use existing backup or create new backup.
 */
public enum class BackupMode(
    public val javaValue: com.pulumi.azurenative.datamigration.enums.BackupMode,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.enums.BackupMode> {
    CreateBackup(com.pulumi.azurenative.datamigration.enums.BackupMode.CreateBackup),
    ExistingBackup(com.pulumi.azurenative.datamigration.enums.BackupMode.ExistingBackup),
    ;

    override fun toJava(): com.pulumi.azurenative.datamigration.enums.BackupMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.enums.BackupMode): BackupMode =
            BackupMode.values().first { it.javaValue == javaType }
    }
}
