@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Target platform for the project
 */
public enum class ProjectTargetPlatform(
    public val javaValue: com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform> {
    SQLDB(com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform.SQLDB),
    SQLMI(com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform.SQLMI),
    AzureDbForMySql(com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform.AzureDbForMySql),
    AzureDbForPostgreSql(com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform.AzureDbForPostgreSql),
    MongoDb(com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform.MongoDb),
    Unknown(com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform.Unknown),
    ;

    override fun toJava(): com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.enums.ProjectTargetPlatform):
            ProjectTargetPlatform = ProjectTargetPlatform.values().first { it.javaValue == javaType }
    }
}
