@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.AzureActiveDirectoryAppArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Active Directory Application
 * @property appKey Key used to authenticate to the Azure Active Directory Application
 * @property applicationId Application ID of the Azure Active Directory Application
 * @property tenantId Tenant id of the customer
 */
public data class AzureActiveDirectoryAppArgs(
    public val appKey: Output<String>,
    public val applicationId: Output<String>,
    public val tenantId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.AzureActiveDirectoryAppArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.AzureActiveDirectoryAppArgs =
        com.pulumi.azurenative.datamigration.inputs.AzureActiveDirectoryAppArgs.builder()
            .appKey(appKey.applyValue({ args0 -> args0 }))
            .applicationId(applicationId.applyValue({ args0 -> args0 }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureActiveDirectoryAppArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryAppArgsBuilder internal constructor() {
    private var appKey: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Key used to authenticate to the Azure Active Directory Application
     */
    @JvmName("ealsprnhflnseaeo")
    public suspend fun appKey(`value`: Output<String>) {
        this.appKey = value
    }

    /**
     * @param value Application ID of the Azure Active Directory Application
     */
    @JvmName("fmmbypbwkmjchwhg")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Tenant id of the customer
     */
    @JvmName("wdcncbfxysiijbgg")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Key used to authenticate to the Azure Active Directory Application
     */
    @JvmName("txesntqhqgipioii")
    public suspend fun appKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appKey = mapped
    }

    /**
     * @param value Application ID of the Azure Active Directory Application
     */
    @JvmName("xlcjmhxogygpgdvf")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Tenant id of the customer
     */
    @JvmName("vjejoeoakxcejrrx")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AzureActiveDirectoryAppArgs = AzureActiveDirectoryAppArgs(
        appKey = appKey ?: throw PulumiNullFieldException("appKey"),
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
    )
}
