@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration for Oracle source.
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync'.
 */
public data class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgsBuilder internal
constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("pvorpcqppjfctqoi")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("dchlnajnkrhowxys")
    public suspend
    fun input(`value`: Output<ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync'.
     */
    @JvmName("seyvoilsggucqjgm")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("bpyisyhaitoqtjgu")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("yaxkfhywlvmmwloy")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("pmagsmfapgssffhs")
    public suspend fun input(`value`: ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("ufwxktotffuyoner")
    public suspend
    fun input(argument: suspend ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync'.
     */
    @JvmName("mdivwogyxijnopqy")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
