@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlDbTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to SQL DB and target server requirements
 * @property targetConnectionInfo Connection information for target SQL DB
 */
public data class ConnectToTargetSqlDbTaskInputArgs(
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlDbTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlDbTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlDbTaskInputArgs.builder()
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToTargetSqlDbTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetSqlDbTaskInputArgsBuilder internal constructor() {
    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value Connection information for target SQL DB
     */
    @JvmName("sgllhwnnvytdcdjq")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Connection information for target SQL DB
     */
    @JvmName("yqpwourvhjfvwdkw")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target SQL DB
     */
    @JvmName("ylsvxbypesakerlj")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ConnectToTargetSqlDbTaskInputArgs = ConnectToTargetSqlDbTaskInputArgs(
        targetConnectionInfo = targetConnectionInfo ?: throw
            PulumiNullFieldException("targetConnectionInfo"),
    )
}
