@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlSqlDbSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to Azure SQL DB and target server requirements
 * @property sourceConnectionInfo Connection information for source SQL Server
 * @property targetConnectionInfo Connection information for target SQL DB
 */
public data class ConnectToTargetSqlSqlDbSyncTaskInputArgs(
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlSqlDbSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlSqlDbSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlSqlDbSyncTaskInputArgs.builder()
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToTargetSqlSqlDbSyncTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetSqlSqlDbSyncTaskInputArgsBuilder internal constructor() {
    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value Connection information for source SQL Server
     */
    @JvmName("hcovkrdubgcnvbul")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for target SQL DB
     */
    @JvmName("kbqcvnlbnqfdoons")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Connection information for source SQL Server
     */
    @JvmName("pkioyxuhastynfkh")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source SQL Server
     */
    @JvmName("yqoadaorfqrgfjok")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for target SQL DB
     */
    @JvmName("pejioumkglgmoyee")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target SQL DB
     */
    @JvmName("ftntflkilphyysea")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ConnectToTargetSqlSqlDbSyncTaskInputArgs =
        ConnectToTargetSqlSqlDbSyncTaskInputArgs(
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
