@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupName Name of the resource group
 * @property serviceName Name of the service
 */
public data class GetServicePlainArgs(
    public val groupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetServicePlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetServicePlainArgs.builder()
            .groupName(groupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var groupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Name of the resource group
     */
    @JvmName("ohxolsstlqnuyrel")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("vhexfsrscdgdodij")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
