@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that collects user tables for the given list of databases
 * @property selectedSourceDatabases List of source database names to collect tables for
 * @property selectedTargetDatabases List of target database names to collect tables for
 * @property sourceConnectionInfo Connection information for SQL Server
 * @property targetConnectionInfo Connection information for SQL DB
 */
public data class GetUserTablesSqlSyncTaskInputArgs(
    public val selectedSourceDatabases: Output<List<String>>,
    public val selectedTargetDatabases: Output<List<String>>,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlSyncTaskInputArgs.builder()
            .selectedSourceDatabases(
                selectedSourceDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .selectedTargetDatabases(
                selectedTargetDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GetUserTablesSqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class GetUserTablesSqlSyncTaskInputArgsBuilder internal constructor() {
    private var selectedSourceDatabases: Output<List<String>>? = null

    private var selectedTargetDatabases: Output<List<String>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value List of source database names to collect tables for
     */
    @JvmName("ukivhkjiijeivqsp")
    public suspend fun selectedSourceDatabases(`value`: Output<List<String>>) {
        this.selectedSourceDatabases = value
    }

    @JvmName("ocfxnngvdbbjhgia")
    public suspend fun selectedSourceDatabases(vararg values: Output<String>) {
        this.selectedSourceDatabases = Output.all(values.asList())
    }

    /**
     * @param values List of source database names to collect tables for
     */
    @JvmName("svtrrmqqhryujpco")
    public suspend fun selectedSourceDatabases(values: List<Output<String>>) {
        this.selectedSourceDatabases = Output.all(values)
    }

    /**
     * @param value List of target database names to collect tables for
     */
    @JvmName("pfhlkefcrodhappl")
    public suspend fun selectedTargetDatabases(`value`: Output<List<String>>) {
        this.selectedTargetDatabases = value
    }

    @JvmName("yrwkekrytptkfoav")
    public suspend fun selectedTargetDatabases(vararg values: Output<String>) {
        this.selectedTargetDatabases = Output.all(values.asList())
    }

    /**
     * @param values List of target database names to collect tables for
     */
    @JvmName("tohehswidyjjyidk")
    public suspend fun selectedTargetDatabases(values: List<Output<String>>) {
        this.selectedTargetDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("goxmmrurwimtdule")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for SQL DB
     */
    @JvmName("cecnhveehcpvdyvc")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value List of source database names to collect tables for
     */
    @JvmName("qjdfygqktifhwvmx")
    public suspend fun selectedSourceDatabases(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedSourceDatabases = mapped
    }

    /**
     * @param values List of source database names to collect tables for
     */
    @JvmName("dribskruutaeqsdu")
    public suspend fun selectedSourceDatabases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedSourceDatabases = mapped
    }

    /**
     * @param value List of target database names to collect tables for
     */
    @JvmName("imhudfjjajwkywba")
    public suspend fun selectedTargetDatabases(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedTargetDatabases = mapped
    }

    /**
     * @param values List of target database names to collect tables for
     */
    @JvmName("bjfxnpbkfmscqsit")
    public suspend fun selectedTargetDatabases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedTargetDatabases = mapped
    }

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("dbbnmfvsucdcpyft")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for SQL Server
     */
    @JvmName("hllxbdskcqqqjknp")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for SQL DB
     */
    @JvmName("yffhlvvvlodslptj")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for SQL DB
     */
    @JvmName("wffcputgwclhvjsv")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): GetUserTablesSqlSyncTaskInputArgs = GetUserTablesSqlSyncTaskInputArgs(
        selectedSourceDatabases = selectedSourceDatabases ?: throw
            PulumiNullFieldException("selectedSourceDatabases"),
        selectedTargetDatabases = selectedTargetDatabases ?: throw
            PulumiNullFieldException("selectedTargetDatabases"),
        sourceConnectionInfo = sourceConnectionInfo ?: throw
            PulumiNullFieldException("sourceConnectionInfo"),
        targetConnectionInfo = targetConnectionInfo ?: throw
            PulumiNullFieldException("targetConnectionInfo"),
    )
}
