@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that collects user tables for the given list of databases
 * @property connectionInfo Connection information for SQL Server
 * @property selectedDatabases List of database names to collect tables for
 */
public data class GetUserTablesSqlTaskInputArgs(
    public val connectionInfo: Output<SqlConnectionInfoArgs>,
    public val selectedDatabases: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlTaskInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesSqlTaskInputArgs.builder()
            .connectionInfo(connectionInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selectedDatabases(selectedDatabases.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetUserTablesSqlTaskInputArgs].
 */
@PulumiTagMarker
public class GetUserTablesSqlTaskInputArgsBuilder internal constructor() {
    private var connectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var selectedDatabases: Output<List<String>>? = null

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("oannkrdyjpwukiut")
    public suspend fun connectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.connectionInfo = value
    }

    /**
     * @param value List of database names to collect tables for
     */
    @JvmName("wctriqktlakrqill")
    public suspend fun selectedDatabases(`value`: Output<List<String>>) {
        this.selectedDatabases = value
    }

    @JvmName("lkqvrxylipnphyab")
    public suspend fun selectedDatabases(vararg values: Output<String>) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values List of database names to collect tables for
     */
    @JvmName("diqxnfkagrbhgaej")
    public suspend fun selectedDatabases(values: List<Output<String>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("kvofqmgittlehaxh")
    public suspend fun connectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionInfo = mapped
    }

    /**
     * @param argument Connection information for SQL Server
     */
    @JvmName("tsviuyrstwbceffs")
    public suspend fun connectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionInfo = mapped
    }

    /**
     * @param value List of database names to collect tables for
     */
    @JvmName("dtkonmdnavqvxclq")
    public suspend fun selectedDatabases(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param values List of database names to collect tables for
     */
    @JvmName("fdrxdcqmiflbsdbi")
    public suspend fun selectedDatabases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    internal fun build(): GetUserTablesSqlTaskInputArgs = GetUserTablesSqlTaskInputArgs(
        connectionInfo = connectionInfo ?: throw PulumiNullFieldException("connectionInfo"),
        selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
    )
}
