@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceAuthKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlMigrationServiceName Name of the SQL Migration Service.
 */
public data class ListSqlMigrationServiceAuthKeysPlainArgs(
    public val resourceGroupName: String,
    public val sqlMigrationServiceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceAuthKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceAuthKeysPlainArgs =
        com.pulumi.azurenative.datamigration.inputs.ListSqlMigrationServiceAuthKeysPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlMigrationServiceName(sqlMigrationServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSqlMigrationServiceAuthKeysPlainArgs].
 */
@PulumiTagMarker
public class ListSqlMigrationServiceAuthKeysPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlMigrationServiceName: String? = null

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ilrmyppyvihcqrjj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Migration Service.
     */
    @JvmName("wpufcxpsaqffxdvt")
    public suspend fun sqlMigrationServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlMigrationServiceName = mapped
    }

    internal fun build(): ListSqlMigrationServiceAuthKeysPlainArgs =
        ListSqlMigrationServiceAuthKeysPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlMigrationServiceName = sqlMigrationServiceName ?: throw
                PulumiNullFieldException("sqlMigrationServiceName"),
        )
}
