@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Database specific information for Oracle to Azure Database for PostgreSQL migration task inputs
 * @property caseManipulation How to handle object name casing: either Preserve or ToLower
 * @property migrationSetting Migration settings which tune the migration behavior
 * @property name Name of the migration pipeline
 * @property schemaName Name of the source schema
 * @property sourceSetting Source settings to tune source endpoint migration behavior
 * @property tableMap Mapping of source to target tables
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 * @property targetSetting Target settings to tune target endpoint migration behavior
 */
public data class MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs(
    public val caseManipulation: Output<String>? = null,
    public val migrationSetting: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val sourceSetting: Output<Map<String, String>>? = null,
    public val tableMap: Output<Map<String, String>>? = null,
    public val targetDatabaseName: Output<String>? = null,
    public val targetSetting: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs.builder()
            .caseManipulation(caseManipulation?.applyValue({ args0 -> args0 }))
            .migrationSetting(
                migrationSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .sourceSetting(
                sourceSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tableMap(
                tableMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetDatabaseName(targetDatabaseName?.applyValue({ args0 -> args0 }))
            .targetSetting(
                targetSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs].
 */
@PulumiTagMarker
public class MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder internal constructor() {
    private var caseManipulation: Output<String>? = null

    private var migrationSetting: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var sourceSetting: Output<Map<String, String>>? = null

    private var tableMap: Output<Map<String, String>>? = null

    private var targetDatabaseName: Output<String>? = null

    private var targetSetting: Output<Map<String, String>>? = null

    /**
     * @param value How to handle object name casing: either Preserve or ToLower
     */
    @JvmName("vjetlgccmkodjbck")
    public suspend fun caseManipulation(`value`: Output<String>) {
        this.caseManipulation = value
    }

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("ajmfonydbenustkg")
    public suspend fun migrationSetting(`value`: Output<Map<String, String>>) {
        this.migrationSetting = value
    }

    /**
     * @param value Name of the migration pipeline
     */
    @JvmName("hrjdhxbmjwdyhotk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the source schema
     */
    @JvmName("rsmeqqfeccnntkkn")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("adaviuyauwjaqqhi")
    public suspend fun sourceSetting(`value`: Output<Map<String, String>>) {
        this.sourceSetting = value
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("jmplekpmgqgqgklw")
    public suspend fun tableMap(`value`: Output<Map<String, String>>) {
        this.tableMap = value
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("lcncfbiimtdermvl")
    public suspend fun targetDatabaseName(`value`: Output<String>) {
        this.targetDatabaseName = value
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("ehfqsoxxmxsrwqkv")
    public suspend fun targetSetting(`value`: Output<Map<String, String>>) {
        this.targetSetting = value
    }

    /**
     * @param value How to handle object name casing: either Preserve or ToLower
     */
    @JvmName("ojwqbwrbqrcdlbic")
    public suspend fun caseManipulation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseManipulation = mapped
    }

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("ioxvrqohvldruunk")
    public suspend fun migrationSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param values Migration settings which tune the migration behavior
     */
    @JvmName("dswimhuxtmsiimfq")
    public fun migrationSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param value Name of the migration pipeline
     */
    @JvmName("ddhufqalwdsaifoj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the source schema
     */
    @JvmName("wwdywggbidplorqg")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("amegaohyfmbckuyr")
    public suspend fun sourceSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param values Source settings to tune source endpoint migration behavior
     */
    @JvmName("yroqfnijamubhqyp")
    public fun sourceSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("sywqkorbjerbgasd")
    public suspend fun tableMap(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param values Mapping of source to target tables
     */
    @JvmName("bahdgtwyrlhomvir")
    public fun tableMap(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("qjrlbjtfktcmivhh")
    public suspend fun targetDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabaseName = mapped
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("hajxhawnshpbrjkb")
    public suspend fun targetSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    /**
     * @param values Target settings to tune target endpoint migration behavior
     */
    @JvmName("iyopyvnirtkkhevx")
    public fun targetSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    internal fun build(): MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs =
        MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs(
            caseManipulation = caseManipulation,
            migrationSetting = migrationSetting,
            name = name,
            schemaName = schemaName,
            sourceSetting = sourceSetting,
            tableMap = tableMap,
            targetDatabaseName = targetDatabaseName,
            targetSetting = targetSetting,
        )
}
