@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source Oracle
 * @property targetConnectionInfo Connection information for target Azure Database for PostgreSQL
 */
public data class MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs(
    public val selectedDatabases: Output<List<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<OracleConnectionInfoArgs>,
    public val targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs.builder()
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class MigrateOracleAzureDbPostgreSqlSyncTaskInputArgsBuilder internal constructor() {
    private var selectedDatabases: Output<List<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs>>? =
        null

    private var sourceConnectionInfo: Output<OracleConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    /**
     * @param value Databases to migrate
     */
    @JvmName("eunjcrgfmnansksy")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("sentmddmyqjvtlbl")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("lysxpgdoxgvgefce")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for source Oracle
     */
    @JvmName("vqmincsvtkstfllv")
    public suspend fun sourceConnectionInfo(`value`: Output<OracleConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL
     */
    @JvmName("rneupqanaguwdeay")
    public suspend fun targetConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("ymmntqfmtmimivbd")
    public suspend
    fun selectedDatabases(`value`: List<MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("hkmgpkllekexrqqy")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("pbbkoocglgiyseyu")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("pmcumpeaagyshxaj")
    public suspend
    fun selectedDatabases(argument: suspend MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("tufqcoctluaktikt")
    public suspend fun selectedDatabases(
        vararg
        values: MigrateOracleAzureDbPostgreSqlSyncDatabaseInputArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Connection information for source Oracle
     */
    @JvmName("woheksrtdgrpqlde")
    public suspend fun sourceConnectionInfo(`value`: OracleConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source Oracle
     */
    @JvmName("leoapdgcmxunmwme")
    public suspend
    fun sourceConnectionInfo(argument: suspend OracleConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = OracleConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL
     */
    @JvmName("mnivxaxotoiyhqhr")
    public suspend fun targetConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for PostgreSQL
     */
    @JvmName("tvmplcauaieongdi")
    public suspend
    fun targetConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs =
        MigrateOracleAzureDbPostgreSqlSyncTaskInputArgs(
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
