@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncDatabaseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Database specific information for SQL to Azure SQL DB sync migration task inputs
 * @property id Unique identifier for database
 * @property migrationSetting Migration settings which tune the migration behavior
 * @property name Name of database
 * @property schemaName Schema name to be migrated
 * @property sourceSetting Source settings to tune source endpoint migration behavior
 * @property tableMap Mapping of source to target tables
 * @property targetDatabaseName Target database name
 * @property targetSetting Target settings to tune target endpoint migration behavior
 */
public data class MigrateSqlServerSqlDbSyncDatabaseInputArgs(
    public val id: Output<String>? = null,
    public val migrationSetting: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val sourceSetting: Output<Map<String, String>>? = null,
    public val tableMap: Output<Map<String, String>>? = null,
    public val targetDatabaseName: Output<String>? = null,
    public val targetSetting: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncDatabaseInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncDatabaseInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncDatabaseInputArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .migrationSetting(
                migrationSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .sourceSetting(
                sourceSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tableMap(
                tableMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetDatabaseName(targetDatabaseName?.applyValue({ args0 -> args0 }))
            .targetSetting(
                targetSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigrateSqlServerSqlDbSyncDatabaseInputArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var migrationSetting: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var sourceSetting: Output<Map<String, String>>? = null

    private var tableMap: Output<Map<String, String>>? = null

    private var targetDatabaseName: Output<String>? = null

    private var targetSetting: Output<Map<String, String>>? = null

    /**
     * @param value Unique identifier for database
     */
    @JvmName("kvahktpbjdkoytta")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("kcakyhqgekcrqeyc")
    public suspend fun migrationSetting(`value`: Output<Map<String, String>>) {
        this.migrationSetting = value
    }

    /**
     * @param value Name of database
     */
    @JvmName("vbdxbsvmmoajwexa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Schema name to be migrated
     */
    @JvmName("xqxvnddtngvmdbho")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("krhynaiiusfdbror")
    public suspend fun sourceSetting(`value`: Output<Map<String, String>>) {
        this.sourceSetting = value
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("edjapxvsobxgvuni")
    public suspend fun tableMap(`value`: Output<Map<String, String>>) {
        this.tableMap = value
    }

    /**
     * @param value Target database name
     */
    @JvmName("ntuduscalfvsrjxr")
    public suspend fun targetDatabaseName(`value`: Output<String>) {
        this.targetDatabaseName = value
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("mvvpvbxdicviuhxd")
    public suspend fun targetSetting(`value`: Output<Map<String, String>>) {
        this.targetSetting = value
    }

    /**
     * @param value Unique identifier for database
     */
    @JvmName("iwvfnyhremwyreie")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("eyahhflfmrkqqnqm")
    public suspend fun migrationSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param values Migration settings which tune the migration behavior
     */
    @JvmName("ldnyatcugemnoaig")
    public fun migrationSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param value Name of database
     */
    @JvmName("kxvhymdljdkjowkl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Schema name to be migrated
     */
    @JvmName("slkfouafnmcrqjny")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("mudqsikxuxbhbvgm")
    public suspend fun sourceSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param values Source settings to tune source endpoint migration behavior
     */
    @JvmName("rmbafkpixycckkby")
    public fun sourceSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("ytnqeobkkbbsvbao")
    public suspend fun tableMap(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param values Mapping of source to target tables
     */
    @JvmName("lsxhmqgucrguyoku")
    public fun tableMap(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param value Target database name
     */
    @JvmName("ewvagtdiyaaeqioh")
    public suspend fun targetDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabaseName = mapped
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("cfesdkruowtampcq")
    public suspend fun targetSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    /**
     * @param values Target settings to tune target endpoint migration behavior
     */
    @JvmName("bcolkwbvvtdmuhhn")
    public fun targetSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    internal fun build(): MigrateSqlServerSqlDbSyncDatabaseInputArgs =
        MigrateSqlServerSqlDbSyncDatabaseInputArgs(
            id = id,
            migrationSetting = migrationSetting,
            name = name,
            schemaName = schemaName,
            sourceSetting = sourceSetting,
            tableMap = tableMap,
            targetDatabaseName = targetDatabaseName,
            targetSetting = targetSetting,
        )
}
