@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for online migrations
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
 */
public data class MigrateSqlServerSqlDbSyncTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<MigrateSqlServerSqlDbSyncTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbSyncTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateSqlServerSqlDbSyncTaskPropertiesArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlDbSyncTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<MigrateSqlServerSqlDbSyncTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("vyvkfnxqryqaosom")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("ahjhvfrbhedvfwpp")
    public suspend fun input(`value`: Output<MigrateSqlServerSqlDbSyncTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
     */
    @JvmName("cmnangkmthusdxqj")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("aktjvcwkxlnugccb")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("nxgpdwkyjppkcplm")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("iufofxnhdvablsev")
    public suspend fun input(`value`: MigrateSqlServerSqlDbSyncTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("omouuxnrjlnilbhm")
    public suspend
    fun input(argument: suspend MigrateSqlServerSqlDbSyncTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateSqlServerSqlDbSyncTaskInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'Migrate.SqlServer.AzureSqlDb.Sync'.
     */
    @JvmName("akddvqethivlnogw")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): MigrateSqlServerSqlDbSyncTaskPropertiesArgs =
        MigrateSqlServerSqlDbSyncTaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
