@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbCollectionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes how an individual MongoDB collection should be migrated
 * @property canDelete Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
 * @property shardKey Describes a MongoDB shard key
 * @property targetRUs The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
 */
public data class MongoDbCollectionSettingsArgs(
    public val canDelete: Output<Boolean>? = null,
    public val shardKey: Output<MongoDbShardKeySettingArgs>? = null,
    public val targetRUs: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbCollectionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbCollectionSettingsArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbCollectionSettingsArgs.builder()
            .canDelete(canDelete?.applyValue({ args0 -> args0 }))
            .shardKey(shardKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetRUs(targetRUs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbCollectionSettingsArgs].
 */
@PulumiTagMarker
public class MongoDbCollectionSettingsArgsBuilder internal constructor() {
    private var canDelete: Output<Boolean>? = null

    private var shardKey: Output<MongoDbShardKeySettingArgs>? = null

    private var targetRUs: Output<Int>? = null

    /**
     * @param value Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
     */
    @JvmName("hsuqvmpkuiptrpgh")
    public suspend fun canDelete(`value`: Output<Boolean>) {
        this.canDelete = value
    }

    /**
     * @param value Describes a MongoDB shard key
     */
    @JvmName("oosyapnshlneqhjl")
    public suspend fun shardKey(`value`: Output<MongoDbShardKeySettingArgs>) {
        this.shardKey = value
    }

    /**
     * @param value The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
     */
    @JvmName("rtteuxkncayiaklr")
    public suspend fun targetRUs(`value`: Output<Int>) {
        this.targetRUs = value
    }

    /**
     * @param value Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
     */
    @JvmName("oycsxxcijvkoqexr")
    public suspend fun canDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canDelete = mapped
    }

    /**
     * @param value Describes a MongoDB shard key
     */
    @JvmName("sfptcsfoyrncyctj")
    public suspend fun shardKey(`value`: MongoDbShardKeySettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardKey = mapped
    }

    /**
     * @param argument Describes a MongoDB shard key
     */
    @JvmName("vawaxvmpbyslestf")
    public suspend fun shardKey(argument: suspend MongoDbShardKeySettingArgsBuilder.() -> Unit) {
        val toBeMapped = MongoDbShardKeySettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shardKey = mapped
    }

    /**
     * @param value The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
     */
    @JvmName("ajsbykhkmoyjwxhc")
    public suspend fun targetRUs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRUs = mapped
    }

    internal fun build(): MongoDbCollectionSettingsArgs = MongoDbCollectionSettingsArgs(
        canDelete = canDelete,
        shardKey = shardKey,
        targetRUs = targetRUs,
    )
}
