@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbThrottlingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies resource limits for the migration
 * @property maxParallelism The maximum number of work items (e.g. collection copies) that will be processed in parallel
 * @property minFreeCpu The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
 * @property minFreeMemoryMb The number of megabytes of RAM that the migrator will try to avoid using
 */
public data class MongoDbThrottlingSettingsArgs(
    public val maxParallelism: Output<Int>? = null,
    public val minFreeCpu: Output<Int>? = null,
    public val minFreeMemoryMb: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbThrottlingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbThrottlingSettingsArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbThrottlingSettingsArgs.builder()
            .maxParallelism(maxParallelism?.applyValue({ args0 -> args0 }))
            .minFreeCpu(minFreeCpu?.applyValue({ args0 -> args0 }))
            .minFreeMemoryMb(minFreeMemoryMb?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbThrottlingSettingsArgs].
 */
@PulumiTagMarker
public class MongoDbThrottlingSettingsArgsBuilder internal constructor() {
    private var maxParallelism: Output<Int>? = null

    private var minFreeCpu: Output<Int>? = null

    private var minFreeMemoryMb: Output<Int>? = null

    /**
     * @param value The maximum number of work items (e.g. collection copies) that will be processed in parallel
     */
    @JvmName("nkmcsfnmtxxeypgj")
    public suspend fun maxParallelism(`value`: Output<Int>) {
        this.maxParallelism = value
    }

    /**
     * @param value The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
     */
    @JvmName("tsrultbfxlmvmsyj")
    public suspend fun minFreeCpu(`value`: Output<Int>) {
        this.minFreeCpu = value
    }

    /**
     * @param value The number of megabytes of RAM that the migrator will try to avoid using
     */
    @JvmName("uwfnpwjtyxhnraac")
    public suspend fun minFreeMemoryMb(`value`: Output<Int>) {
        this.minFreeMemoryMb = value
    }

    /**
     * @param value The maximum number of work items (e.g. collection copies) that will be processed in parallel
     */
    @JvmName("ymvicfdjihgdldto")
    public suspend fun maxParallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxParallelism = mapped
    }

    /**
     * @param value The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
     */
    @JvmName("tuohhsnccybgqfbf")
    public suspend fun minFreeCpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minFreeCpu = mapped
    }

    /**
     * @param value The number of megabytes of RAM that the migrator will try to avoid using
     */
    @JvmName("guxknwnkfeotsbpw")
    public suspend fun minFreeMemoryMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minFreeMemoryMb = mapped
    }

    internal fun build(): MongoDbThrottlingSettingsArgs = MongoDbThrottlingSettingsArgs(
        maxParallelism = maxParallelism,
        minFreeCpu = minFreeCpu,
        minFreeMemoryMb = minFreeMemoryMb,
    )
}
