@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ProjectFilePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Base class for file properties.
 * @property extension Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
 * @property filePath Relative path of this file resource. This property can be set when creating or updating the file resource.
 * @property mediaType File content type. This property can be modified to reflect the file content type.
 */
public data class ProjectFilePropertiesArgs(
    public val extension: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val mediaType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ProjectFilePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.ProjectFilePropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.ProjectFilePropertiesArgs.builder()
            .extension(extension?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .mediaType(mediaType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectFilePropertiesArgs].
 */
@PulumiTagMarker
public class ProjectFilePropertiesArgsBuilder internal constructor() {
    private var extension: Output<String>? = null

    private var filePath: Output<String>? = null

    private var mediaType: Output<String>? = null

    /**
     * @param value Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
     */
    @JvmName("ussdlhfqmnatqiby")
    public suspend fun extension(`value`: Output<String>) {
        this.extension = value
    }

    /**
     * @param value Relative path of this file resource. This property can be set when creating or updating the file resource.
     */
    @JvmName("jxgogiwgxhyfedbs")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value File content type. This property can be modified to reflect the file content type.
     */
    @JvmName("mhqbuhxdotcfqstd")
    public suspend fun mediaType(`value`: Output<String>) {
        this.mediaType = value
    }

    /**
     * @param value Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
     */
    @JvmName("sxdusysibjctliwu")
    public suspend fun extension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extension = mapped
    }

    /**
     * @param value Relative path of this file resource. This property can be set when creating or updating the file resource.
     */
    @JvmName("hsubcdetytyxwhpm")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value File content type. This property can be modified to reflect the file content type.
     */
    @JvmName("bedcsnbfhemtbvam")
    public suspend fun mediaType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaType = mapped
    }

    internal fun build(): ProjectFilePropertiesArgs = ProjectFilePropertiesArgs(
        extension = extension,
        filePath = filePath,
        mediaType = mediaType,
    )
}
