@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.SqlConnectionInfoArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.AuthenticationType
import com.pulumi.azurenative.datamigration.kotlin.enums.SqlSourcePlatform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information for connecting to SQL database server
 * @property additionalSettings Additional connection settings
 * @property authentication Authentication type to use for connection
 * @property dataSource Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
 * @property encryptConnection Whether to encrypt the connection
 * @property password Password credential.
 * @property platform Server platform type for connection
 * @property trustServerCertificate Whether to trust the server certificate
 * @property type Type of connection info
 * Expected value is 'SqlConnectionInfo'.
 * @property userName User name
 */
public data class SqlConnectionInfoArgs(
    public val additionalSettings: Output<String>? = null,
    public val authentication: Output<Either<String, AuthenticationType>>? = null,
    public val dataSource: Output<String>,
    public val encryptConnection: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val platform: Output<Either<String, SqlSourcePlatform>>? = null,
    public val trustServerCertificate: Output<Boolean>? = null,
    public val type: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.SqlConnectionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.SqlConnectionInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.SqlConnectionInfoArgs.builder()
            .additionalSettings(additionalSettings?.applyValue({ args0 -> args0 }))
            .authentication(
                authentication?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataSource(dataSource.applyValue({ args0 -> args0 }))
            .encryptConnection(encryptConnection?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .platform(
                platform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .trustServerCertificate(trustServerCertificate?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlConnectionInfoArgs].
 */
@PulumiTagMarker
public class SqlConnectionInfoArgsBuilder internal constructor() {
    private var additionalSettings: Output<String>? = null

    private var authentication: Output<Either<String, AuthenticationType>>? = null

    private var dataSource: Output<String>? = null

    private var encryptConnection: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var platform: Output<Either<String, SqlSourcePlatform>>? = null

    private var trustServerCertificate: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Additional connection settings
     */
    @JvmName("qwwbncviywfxhfqy")
    public suspend fun additionalSettings(`value`: Output<String>) {
        this.additionalSettings = value
    }

    /**
     * @param value Authentication type to use for connection
     */
    @JvmName("emrkcdgtnuxvenux")
    public suspend fun authentication(`value`: Output<Either<String, AuthenticationType>>) {
        this.authentication = value
    }

    /**
     * @param value Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
     */
    @JvmName("liyajmtvluwrdwwd")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Whether to encrypt the connection
     */
    @JvmName("kllhkocxjnxhtppr")
    public suspend fun encryptConnection(`value`: Output<Boolean>) {
        this.encryptConnection = value
    }

    /**
     * @param value Password credential.
     */
    @JvmName("vyulxqnbpnfpuayg")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Server platform type for connection
     */
    @JvmName("cmoqbfrsclbvwyhj")
    public suspend fun platform(`value`: Output<Either<String, SqlSourcePlatform>>) {
        this.platform = value
    }

    /**
     * @param value Whether to trust the server certificate
     */
    @JvmName("ybsfkfjniafinsxs")
    public suspend fun trustServerCertificate(`value`: Output<Boolean>) {
        this.trustServerCertificate = value
    }

    /**
     * @param value Type of connection info
     * Expected value is 'SqlConnectionInfo'.
     */
    @JvmName("bktydpsccpkxangg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name
     */
    @JvmName("hqjygrspiymfkcac")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Additional connection settings
     */
    @JvmName("jxqmepridpgfxiib")
    public suspend fun additionalSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalSettings = mapped
    }

    /**
     * @param value Authentication type to use for connection
     */
    @JvmName("veeaohvcsdbmtrut")
    public suspend fun authentication(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value Authentication type to use for connection
     */
    @JvmName("pksarlpgglebnxul")
    public fun authentication(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value Authentication type to use for connection
     */
    @JvmName("sqovcnrwdadvyeni")
    public fun authentication(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
     */
    @JvmName("djngravjviinhlvm")
    public suspend fun dataSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Whether to encrypt the connection
     */
    @JvmName("drtrkpwtfkmevnqm")
    public suspend fun encryptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptConnection = mapped
    }

    /**
     * @param value Password credential.
     */
    @JvmName("sbwmnuiwedpelkmn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Server platform type for connection
     */
    @JvmName("raellnvvlludvaky")
    public suspend fun platform(`value`: Either<String, SqlSourcePlatform>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Server platform type for connection
     */
    @JvmName("uoqwqgcvpnkjkyrl")
    public fun platform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlSourcePlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Server platform type for connection
     */
    @JvmName("fmvhbqevcmkcmuqi")
    public fun platform(`value`: SqlSourcePlatform) {
        val toBeMapped = Either.ofRight<String, SqlSourcePlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Whether to trust the server certificate
     */
    @JvmName("nwhjjcfwqnswbwhv")
    public suspend fun trustServerCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustServerCertificate = mapped
    }

    /**
     * @param value Type of connection info
     * Expected value is 'SqlConnectionInfo'.
     */
    @JvmName("tdvskttejvlpluxn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name
     */
    @JvmName("bptechqguxycmyta")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SqlConnectionInfoArgs = SqlConnectionInfoArgs(
        additionalSettings = additionalSettings,
        authentication = authentication,
        dataSource = dataSource ?: throw PulumiNullFieldException("dataSource"),
        encryptConnection = encryptConnection,
        password = password,
        platform = platform,
        trustServerCertificate = trustServerCertificate,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
