@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ValidateSyncMigrationInputSqlServerTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for task that validates migration input for SQL sync migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Information for connecting to source SQL server
 * @property targetConnectionInfo Information for connecting to target
 */
public data class ValidateSyncMigrationInputSqlServerTaskInputArgs(
    public val selectedDatabases: Output<List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ValidateSyncMigrationInputSqlServerTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ValidateSyncMigrationInputSqlServerTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ValidateSyncMigrationInputSqlServerTaskInputArgs.builder()
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ValidateSyncMigrationInputSqlServerTaskInputArgs].
 */
@PulumiTagMarker
public class ValidateSyncMigrationInputSqlServerTaskInputArgsBuilder internal constructor() {
    private var selectedDatabases: Output<List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value Databases to migrate
     */
    @JvmName("vdiaqvlxgspkbfgm")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("dhebymufdafhvugk")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateSqlServerSqlDbSyncDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("ivvhgictimcdjtxh")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateSqlServerSqlDbSyncDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Information for connecting to source SQL server
     */
    @JvmName("cqswmoaijkjnypgp")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("ebgwodutefalujmw")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("hcpvbkhxjsxxjdbk")
    public suspend fun selectedDatabases(`value`: List<MigrateSqlServerSqlDbSyncDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("umsftotcpiooqanl")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("jjfdxbjvrwmucfwd")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("bapobqxmjpsgagbv")
    public suspend
    fun selectedDatabases(argument: suspend MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateSqlServerSqlDbSyncDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("bbdbynycboqvlelu")
    public suspend fun selectedDatabases(vararg values: MigrateSqlServerSqlDbSyncDatabaseInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Information for connecting to source SQL server
     */
    @JvmName("chbkbsenfbcbxgbc")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to source SQL server
     */
    @JvmName("ssolobnwthkmmwhn")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("ymbdnmlivddtjsrw")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to target
     */
    @JvmName("yotovwiseghltkab")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ValidateSyncMigrationInputSqlServerTaskInputArgs =
        ValidateSyncMigrationInputSqlServerTaskInputArgs(
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
