@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information of backup set
 * @property backupFinishedDate Date and time that the backup operation finished
 * @property backupSetId Id for the set of backup files
 * @property backupStartDate Date and time that the backup operation began
 * @property backupType Enum of the different backup types
 * @property databaseName Name of the database to which the backup set belongs
 * @property firstLsn First log sequence number of the backup file
 * @property isBackupRestored Whether the backup set is restored or not
 * @property lastLsn Last log sequence number of the backup file
 * @property lastModifiedTime Last modified time of the backup file in share location
 * @property listOfBackupFiles List of files in the backup set
 */
public data class BackupSetInfoResponse(
    public val backupFinishedDate: String? = null,
    public val backupSetId: String? = null,
    public val backupStartDate: String? = null,
    public val backupType: String? = null,
    public val databaseName: String? = null,
    public val firstLsn: String? = null,
    public val isBackupRestored: Boolean? = null,
    public val lastLsn: String? = null,
    public val lastModifiedTime: String? = null,
    public val listOfBackupFiles: List<BackupFileInfoResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.BackupSetInfoResponse):
            BackupSetInfoResponse = BackupSetInfoResponse(
            backupFinishedDate = javaType.backupFinishedDate().map({ args0 -> args0 }).orElse(null),
            backupSetId = javaType.backupSetId().map({ args0 -> args0 }).orElse(null),
            backupStartDate = javaType.backupStartDate().map({ args0 -> args0 }).orElse(null),
            backupType = javaType.backupType().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            firstLsn = javaType.firstLsn().map({ args0 -> args0 }).orElse(null),
            isBackupRestored = javaType.isBackupRestored().map({ args0 -> args0 }).orElse(null),
            lastLsn = javaType.lastLsn().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            listOfBackupFiles = javaType.listOfBackupFiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.BackupFileInfoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
