@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements
 * @property sourceConnectionInfo Connection information for source PostgreSQL server
 * @property targetConnectionInfo Connection information for target Azure Database for PostgreSQL server
 */
public data class ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse(
    public val sourceConnectionInfo: PostgreSqlConnectionInfoResponse,
    public val targetConnectionInfo: PostgreSqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse):
            ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse =
            ConnectToTargetAzureDbForPostgreSqlSyncTaskInputResponse(
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.PostgreSqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.PostgreSqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
