@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Results for checksum based Data Integrity validation results
 * @property failedObjects List of failed table names of source and target pair
 * @property validationErrors List of errors that happened while performing data integrity validation
 */
public data class DataIntegrityValidationResultResponse(
    public val failedObjects: Map<String, String>? = null,
    public val validationErrors: ValidationErrorResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.DataIntegrityValidationResultResponse):
            DataIntegrityValidationResultResponse = DataIntegrityValidationResultResponse(
            failedObjects = javaType.failedObjects().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ValidationErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
