@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Database file specific information
 * @property databaseName Name of the database
 * @property fileType Database file type
 * @property id Unique identifier for database file
 * @property logicalName Logical name of the file
 * @property physicalFullName Operating-system full path of the file
 * @property restoreFullName Suggested full path of the file for restoring
 * @property sizeMB Size of the file in megabytes
 */
public data class DatabaseFileInfoResponse(
    public val databaseName: String? = null,
    public val fileType: String? = null,
    public val id: String? = null,
    public val logicalName: String? = null,
    public val physicalFullName: String? = null,
    public val restoreFullName: String? = null,
    public val sizeMB: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.DatabaseFileInfoResponse):
            DatabaseFileInfoResponse = DatabaseFileInfoResponse(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            fileType = javaType.fileType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            logicalName = javaType.logicalName().map({ args0 -> args0 }).orElse(null),
            physicalFullName = javaType.physicalFullName().map({ args0 -> args0 }).orElse(null),
            restoreFullName = javaType.restoreFullName().map({ args0 -> args0 }).orElse(null),
            sizeMB = javaType.sizeMB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
