@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Summary of database results in the migration
 * @property endedOn Migration end time
 * @property errorPrefix Wildcard string prefix to use for querying all errors of the item
 * @property itemsCompletedCount Number of successfully completed items
 * @property itemsCount Number of items
 * @property name Name of the item
 * @property resultPrefix Wildcard string prefix to use for querying all sub-tem results of the item
 * @property sizeMB Size of the database in megabytes
 * @property startedOn Migration start time
 * @property state Current state of migration
 * @property statusMessage Status message
 */
public data class DatabaseSummaryResultResponse(
    public val endedOn: String,
    public val errorPrefix: String,
    public val itemsCompletedCount: Double,
    public val itemsCount: Double,
    public val name: String,
    public val resultPrefix: String,
    public val sizeMB: Double,
    public val startedOn: String,
    public val state: String,
    public val statusMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.DatabaseSummaryResultResponse):
            DatabaseSummaryResultResponse = DatabaseSummaryResultResponse(
            endedOn = javaType.endedOn(),
            errorPrefix = javaType.errorPrefix(),
            itemsCompletedCount = javaType.itemsCompletedCount(),
            itemsCount = javaType.itemsCount(),
            name = javaType.name(),
            resultPrefix = javaType.resultPrefix(),
            sizeMB = javaType.sizeMB(),
            startedOn = javaType.startedOn(),
            state = javaType.state(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
